/*******************************************************************************
 * Copyright (c) 2000, 2018 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.ui.typehierarchy;

import java.util.List;

import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

/**
 * A viewer including the content provider for the supertype hierarchy. Used by
 * the TypeHierarchyViewPart which has to provide a TypeHierarchyLifeCycle on
 * construction (shared type hierarchy)
 */
public class SuperTypeHierarchyViewer extends TypeHierarchyViewer {

	public SuperTypeHierarchyViewer(Composite parent,
			TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part,
			IPreferenceStore store) {
		super(parent, new SuperTypeHierarchyContentProvider(lifeCycle),
				lifeCycle, part, store);
	}

	@Override
	public String getTitle() {
		if (isMethodFiltering()) {
			return TypeHierarchyMessages.SuperTypeHierarchyViewer_filtered_title;
		}
		return TypeHierarchyMessages.SuperTypeHierarchyViewer_title;
	}

	@Override
	public void updateContent(boolean expand) {
		getTree().setRedraw(false);
		refresh();
		if (expand) {
			expandAll();
		}
		getTree().setRedraw(true);
	}

	/*
	 * Content provider for the supertype hierarchy
	 */
	public static class SuperTypeHierarchyContentProvider
			extends TypeHierarchyContentProvider {
		public SuperTypeHierarchyContentProvider(
				TypeHierarchyLifeCycle lifeCycle) {
			super(lifeCycle);
		}

		@Override
		protected final void getTypesInHierarchy(IType type, List res) {
			ITypeHierarchy hierarchy = getHierarchy();
			if (hierarchy != null) {
				IType[] types = hierarchy.getSupertypes(type);
				if (types != null) {
					for (int i = 0; i < types.length; i++) {
						res.add(types[i]);
					}
				}
			}
		}

		@Override
		protected IType[] getParentType(IType type) {
			return null;
		}
	}

}
