/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.LibraryLocation;

public class TclLibpathUtils {
    public static final String TCLLIBPATH = "TCLLIBPATH";

    public static void addTclLibPath(InterpreterConfig config, LibraryLocation[] libraries, IEnvironment environment) {
        if (libraries == null) {
            return;
        }
        String currentValue = config.removeEnvVar(TCLLIBPATH);
        IPath[] paths = new IPath[libraries.length];
        int i = 0;
        LibraryLocation[] libraryLocationArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryLocation loc = libraryLocationArray[n2];
            paths[i++] = EnvironmentPathUtils.getLocalPath((IPath)loc.getLibraryPath());
            ++n2;
        }
        StringBuffer sb = new StringBuffer();
        i = 0;
        while (i < paths.length) {
            IFileHandle file = config.getEnvironment().getFile(paths[i]);
            if (file != null) {
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(file.toOSString());
                sb.append('}');
            }
            ++i;
        }
        if (currentValue != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(TclLibpathUtils.convertToTclLibPathFormat(currentValue));
        }
        if (sb.length() != 0) {
            config.addEnvVar(TCLLIBPATH, sb.toString());
        }
    }

    public static String convertToTclLibPathFormat(String currentValue) {
        if ((currentValue = currentValue.trim()).startsWith("'") && currentValue.endsWith("'") && currentValue.length() >= 2) {
            return TclLibpathUtils.convertToTCLLIBPATH(currentValue.substring(1, currentValue.length() - 1));
        }
        if (currentValue.startsWith("\"") && currentValue.endsWith("\"") && currentValue.length() >= 2) {
            return TclLibpathUtils.convertToTCLLIBPATH(currentValue.substring(1, currentValue.length() - 1));
        }
        return currentValue;
    }

    public static String convertToTCLLIBPATH(String value) {
        String replacement = "%%11213@@";
        if (value.contains("\\ ")) {
            if (value.contains(replacement)) {
                replacement = String.valueOf(replacement) + System.currentTimeMillis() + "#";
            }
            value = value.replace("\\ ", replacement);
        }
        String[] values = value.split("\\s");
        StringBuffer sb = new StringBuffer();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!val.startsWith("{") || !val.endsWith("}")) {
                sb.append('{');
                sb.append(val.replace(replacement, "\\ "));
                sb.append('}').append(" ");
            } else {
                sb.append(val).append(" ");
            }
            ++n2;
        }
        return sb.toString();
    }
}

