/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.definitions.impl;

import org.eclipse.dltk.tcl.definitions.ArgumentType;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.definitions.ComplexArgument;
import org.eclipse.dltk.tcl.definitions.Constant;
import org.eclipse.dltk.tcl.definitions.DefinitionsFactory;
import org.eclipse.dltk.tcl.definitions.DefinitionsPackage;
import org.eclipse.dltk.tcl.definitions.Group;
import org.eclipse.dltk.tcl.definitions.Namespace;
import org.eclipse.dltk.tcl.definitions.Scope;
import org.eclipse.dltk.tcl.definitions.Switch;
import org.eclipse.dltk.tcl.definitions.TypedArgument;
import org.eclipse.dltk.tcl.definitions.impl.CommandImpl;
import org.eclipse.dltk.tcl.definitions.impl.ComplexArgumentImpl;
import org.eclipse.dltk.tcl.definitions.impl.ConstantImpl;
import org.eclipse.dltk.tcl.definitions.impl.GroupImpl;
import org.eclipse.dltk.tcl.definitions.impl.NamespaceImpl;
import org.eclipse.dltk.tcl.definitions.impl.ScopeImpl;
import org.eclipse.dltk.tcl.definitions.impl.SwitchImpl;
import org.eclipse.dltk.tcl.definitions.impl.TypedArgumentImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DefinitionsFactoryImpl
extends EFactoryImpl
implements DefinitionsFactory {
    public static DefinitionsFactory init() {
        try {
            DefinitionsFactory theDefinitionsFactory = (DefinitionsFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/dltk/tcl/parserules.ecore");
            if (theDefinitionsFactory != null) {
                return theDefinitionsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DefinitionsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createCommand();
            }
            case 2: {
                return this.createScope();
            }
            case 3: {
                return this.createConstant();
            }
            case 4: {
                return this.createGroup();
            }
            case 5: {
                return this.createSwitch();
            }
            case 6: {
                return this.createTypedArgument();
            }
            case 7: {
                return this.createNamespace();
            }
            case 8: {
                return this.createComplexArgument();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createArgumentTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertArgumentTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Command createCommand() {
        CommandImpl command = new CommandImpl();
        return command;
    }

    @Override
    public Scope createScope() {
        ScopeImpl scope = new ScopeImpl();
        return scope;
    }

    @Override
    public Constant createConstant() {
        ConstantImpl constant = new ConstantImpl();
        return constant;
    }

    @Override
    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    @Override
    public Switch createSwitch() {
        SwitchImpl switch_ = new SwitchImpl();
        return switch_;
    }

    @Override
    public TypedArgument createTypedArgument() {
        TypedArgumentImpl typedArgument = new TypedArgumentImpl();
        return typedArgument;
    }

    @Override
    public Namespace createNamespace() {
        NamespaceImpl namespace = new NamespaceImpl();
        return namespace;
    }

    @Override
    public ComplexArgument createComplexArgument() {
        ComplexArgumentImpl complexArgument = new ComplexArgumentImpl();
        return complexArgument;
    }

    public ArgumentType createArgumentTypeFromString(EDataType eDataType, String initialValue) {
        ArgumentType result = ArgumentType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertArgumentTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DefinitionsPackage getDefinitionsPackage() {
        return (DefinitionsPackage)this.getEPackage();
    }

    @Deprecated
    public static DefinitionsPackage getPackage() {
        return DefinitionsPackage.eINSTANCE;
    }
}

