/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.WorkingSets;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.ImportMavenProjectsJob;
import org.eclipse.m2e.core.ui.internal.wizards.MavenImportWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;

public class MavenImportWizard
extends AbstractMavenProjectWizard
implements IImportWizard {
    private MavenImportWizardPage page;
    private List<String> locations;
    private boolean showLocation = true;
    private boolean basedirRemameRequired = false;
    private boolean initialized = false;

    public MavenImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenImportWizard_title);
    }

    public MavenImportWizard(ProjectImportConfiguration importConfiguration, List<String> locations) {
        this();
        this.locations = locations;
        this.showLocation = false;
    }

    public void setBasedirRemameRequired(boolean basedirRemameRequired) {
        this.basedirRemameRequired = basedirRemameRequired;
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IPath location;
        super.init(workbench, selection);
        this.initialized = true;
        if ((this.locations == null || this.locations.isEmpty()) && (location = SelectionUtil.getSelectedLocation(selection)) != null) {
            this.locations = Collections.singletonList(location.toOSString());
        }
    }

    public void addPages() {
        if (!this.initialized) {
            this.init(null, null);
        }
        this.page = new MavenImportWizardPage(this.importConfiguration);
        this.page.setLocations(this.locations);
        this.page.setShowLocation(this.showLocation);
        this.page.setBasedirRemameRequired(this.basedirRemameRequired);
        if (this.selection != null && this.selection.size() == 1) {
            IWorkingSet workingSet = SelectionUtil.getType(this.selection.getFirstElement(), IWorkingSet.class);
            String JDT_OTHER_PROJECTS = "org.eclipse.jdt.internal.ui.OthersWorkingSet";
            if (workingSet != null && !JDT_OTHER_PROJECTS.equals(workingSet.getId())) {
                this.page.setWorkingSetName(workingSet.getName());
            }
        }
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        IWorkingSet workingSet;
        if (!this.page.isPageComplete()) {
            return false;
        }
        Collection<MavenProjectInfo> projects = this.getProjects();
        ArrayList<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();
        if (this.page.shouldCreateWorkingSet() && !projects.isEmpty() && !workingSets.contains(workingSet = WorkingSets.getOrCreateWorkingSet(this.page.getWorkingSetName()))) {
            workingSets.add(workingSet);
        }
        ImportMavenProjectsJob job = new ImportMavenProjectsJob(projects, workingSets, this.importConfiguration);
        job.schedule();
        return true;
    }

    public Collection<MavenProjectInfo> getProjects() {
        return this.page.getProjects();
    }
}

