/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.MavenDependenciesWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardLocationPage;
import org.eclipse.m2e.scm.MavenProjectPomScanner;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.m2e.scm.internal.wizards.MavenProjectCheckoutJob;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class MavenMaterializePomWizard
extends AbstractMavenProjectWizard
implements IImportWizard,
INewWizard {
    MavenDependenciesWizardPage selectionPage;
    MavenProjectWizardLocationPage locationPage;
    Button checkOutAllButton;
    Button useDeveloperConnectionButton;
    private Dependency[] dependencies;

    public MavenMaterializePomWizard() {
        this.importConfiguration = new ProjectImportConfiguration();
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenMaterializePomWizard_title);
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (Object element : selection) {
            ArtifactKey artifactKey = (ArtifactKey)SelectionUtil.getType(element, ArtifactKey.class);
            if (artifactKey == null) continue;
            Dependency d = new Dependency();
            d.setGroupId(artifactKey.groupId());
            d.setArtifactId(artifactKey.artifactId());
            d.setVersion(artifactKey.version());
            d.setClassifier(artifactKey.classifier());
            dependencies.add(d);
        }
        this.setDependencies(dependencies.toArray(new Dependency[dependencies.size()]));
    }

    public void addPages() {
        this.selectionPage = new MavenDependenciesWizardPage(this.importConfiguration, Messages.MavenMaterializePomWizard_dialog_title, Messages.MavenMaterializePomWizard_dialog_message){

            protected void createAdvancedSettings(Composite composite, GridData gridData) {
                MavenMaterializePomWizard.this.checkOutAllButton = new Button(composite, 32);
                MavenMaterializePomWizard.this.checkOutAllButton.setText(Messages.MavenMaterializePomWizard_btnCheckout);
                MavenMaterializePomWizard.this.checkOutAllButton.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
                MavenMaterializePomWizard.this.useDeveloperConnectionButton = new Button(composite, 32);
                MavenMaterializePomWizard.this.useDeveloperConnectionButton.setText(Messages.MavenMaterializePomWizard_btnDev);
                MavenMaterializePomWizard.this.useDeveloperConnectionButton.setLayoutData((Object)new GridData(4, 128, false, false, 3, 1));
                super.createAdvancedSettings(composite, gridData);
            }
        };
        this.selectionPage.setDependencies(this.dependencies);
        this.locationPage = new MavenProjectWizardLocationPage(this.importConfiguration, Messages.MavenMaterializePomWizard_location_title, Messages.MavenMaterializePomWizard_location_message, this.workingSets);
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation((IStructuredSelection)this.selection));
        this.addPage((IWizardPage)this.selectionPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        final List dependencies = this.selectionPage.getDependencies();
        boolean checkoutAllProjects = this.checkOutAllButton.getSelection();
        final boolean developer = this.useDeveloperConnectionButton.getSelection();
        MavenProjectCheckoutJob job = new MavenProjectCheckoutJob(this.importConfiguration, checkoutAllProjects, this.workingSets){

            protected List<MavenProjectScmInfo> getProjects(IProgressMonitor monitor) throws InterruptedException {
                MavenProjectPomScanner scanner = new MavenProjectPomScanner(developer, dependencies);
                scanner.run(monitor);
                return scanner.getProjects();
            }
        };
        if (!this.locationPage.isInWorkspace()) {
            job.setLocation(this.locationPage.getLocationPath().toFile());
        }
        job.schedule();
        return true;
    }
}

