/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.Surface;

public class Texture
extends Surface {
    private static TexturePaint bluedots;
    private static TexturePaint greendots;
    private static TexturePaint triangles;
    private static TexturePaint blacklines;
    private static TexturePaint gradient;

    public Texture() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        Rectangle r = new Rectangle(10, 10, w - 20, h / 2 - 20);
        g2.setPaint(gradient);
        g2.fill(r);
        g2.setPaint(Color.GREEN);
        g2.setStroke(new BasicStroke(20.0f));
        g2.draw(r);
        g2.setPaint(blacklines);
        g2.setStroke(new BasicStroke(15.0f));
        g2.draw(r);
        Font f = new Font("Serif", 1, w / 5);
        TextLayout tl = new TextLayout("Texture", f, g2.getFontRenderContext());
        int sw = (int)tl.getBounds().getWidth();
        int sh = (int)tl.getBounds().getHeight();
        Shape sha = tl.getOutline(AffineTransform.getTranslateInstance(w / 2 - sw / 2, (double)h * 0.25 + (double)(sh / 2)));
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(3.0f));
        g2.draw(sha);
        g2.setPaint(greendots);
        g2.fill(sha);
        r.setLocation(10, h / 2 + 10);
        g2.setPaint(triangles);
        g2.fill(r);
        g2.setPaint(blacklines);
        g2.setStroke(new BasicStroke(20.0f));
        g2.draw(r);
        g2.setPaint(Color.GREEN);
        g2.setStroke(new BasicStroke(4.0f));
        g2.draw(r);
        f = new Font("Serif", 1, w / 4);
        tl = new TextLayout("Paint", f, g2.getFontRenderContext());
        sw = (int)tl.getBounds().getWidth();
        sh = (int)tl.getBounds().getHeight();
        sha = tl.getOutline(AffineTransform.getTranslateInstance(w / 2 - sw / 2, (double)h * 0.75 + (double)(sh / 2)));
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(5.0f));
        g2.draw(sha);
        g2.setPaint(bluedots);
        g2.fill(sha);
    }

    public static void main(String[] s) {
        Texture.createDemoFrame(new Texture());
    }

    static {
        BufferedImage bi = new BufferedImage(10, 10, 1);
        Graphics2D gi = bi.createGraphics();
        gi.setBackground(Color.WHITE);
        gi.clearRect(0, 0, 10, 10);
        GeneralPath p1 = new GeneralPath();
        p1.moveTo(0.0f, 0.0f);
        p1.lineTo(5.0f, 10.0f);
        p1.lineTo(10.0f, 0.0f);
        p1.closePath();
        gi.setColor(Color.LIGHT_GRAY);
        gi.fill(p1);
        triangles = new TexturePaint(bi, new Rectangle(0, 0, 10, 10));
        bi = new BufferedImage(5, 5, 1);
        gi = bi.createGraphics();
        gi.setColor(Color.BLACK);
        gi.fillRect(0, 0, 5, 5);
        gi.setColor(Color.GRAY);
        gi.fillRect(1, 1, 4, 4);
        blacklines = new TexturePaint(bi, new Rectangle(0, 0, 5, 5));
        int w = 30;
        int h = 30;
        bi = new BufferedImage(w, h, 1);
        gi = bi.createGraphics();
        Color oc = Color.WHITE;
        Color ic = Color.LIGHT_GRAY;
        gi.setPaint(new GradientPaint(0.0f, 0.0f, oc, (float)w * 0.35f, (float)h * 0.35f, ic));
        gi.fillRect(0, 0, w / 2, h / 2);
        gi.setPaint(new GradientPaint(w, 0.0f, oc, (float)w * 0.65f, (float)h * 0.35f, ic));
        gi.fillRect(w / 2, 0, w / 2, h / 2);
        gi.setPaint(new GradientPaint(0.0f, h, oc, (float)w * 0.35f, (float)h * 0.65f, ic));
        gi.fillRect(0, h / 2, w / 2, h / 2);
        gi.setPaint(new GradientPaint(w, h, oc, (float)w * 0.65f, (float)h * 0.65f, ic));
        gi.fillRect(w / 2, h / 2, w / 2, h / 2);
        gradient = new TexturePaint(bi, new Rectangle(0, 0, w, h));
        bi = new BufferedImage(2, 2, 1);
        bi.setRGB(0, 0, -1);
        bi.setRGB(1, 0, -1);
        bi.setRGB(0, 1, -1);
        bi.setRGB(1, 1, -16776961);
        bluedots = new TexturePaint(bi, new Rectangle(0, 0, 2, 2));
        bi = new BufferedImage(2, 2, 1);
        bi.setRGB(0, 0, -1);
        bi.setRGB(1, 0, -1);
        bi.setRGB(0, 1, -1);
        bi.setRGB(1, 1, -16711936);
        greendots = new TexturePaint(bi, new Rectangle(0, 0, 2, 2));
    }
}

