/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.whitebox.code;

import java.lang.reflect.Method;
import jdk.test.whitebox.WhiteBox;

public class Compiler {
    private static final WhiteBox WB = WhiteBox.getWhiteBox();

    public static boolean isC2OrJVMCIIncluded() {
        return WB.isC2OrJVMCIIncluded();
    }

    public static boolean isJVMCIEnabled() {
        Boolean enableJvmci = WB.getBooleanVMFlag("EnableJVMCI");
        return enableJvmci != null && enableJvmci != false;
    }

    public static boolean isGraalEnabled() {
        Boolean useCompiler = WB.getBooleanVMFlag("UseCompiler");
        if (useCompiler == null || !useCompiler.booleanValue()) {
            return false;
        }
        Boolean useJvmciComp = WB.getBooleanVMFlag("UseJVMCICompiler");
        if (useJvmciComp == null || !useJvmciComp.booleanValue()) {
            return false;
        }
        Boolean tieredCompilation = WB.getBooleanVMFlag("TieredCompilation");
        Long compLevel = WB.getIntxVMFlag("TieredStopAtLevel");
        return tieredCompilation == null || tieredCompilation == false || compLevel == null || compLevel > 3L;
    }

    public static boolean isLibgraalEnabled() {
        if (!Compiler.isGraalEnabled()) {
            return false;
        }
        Boolean useJvmciNativeLibrary = WB.getBooleanVMFlag("UseJVMCINativeLibrary");
        return useJvmciNativeLibrary != null && useJvmciNativeLibrary != false;
    }

    public static boolean isC2Enabled() {
        Boolean useCompiler = WB.getBooleanVMFlag("UseCompiler");
        if (useCompiler == null || !useCompiler.booleanValue()) {
            return false;
        }
        Boolean serverMode = WB.getBooleanVMFlag("ProfileInterpreter");
        if (serverMode == null || !serverMode.booleanValue()) {
            return false;
        }
        Boolean tieredCompilation = WB.getBooleanVMFlag("TieredCompilation");
        Long compLevel = WB.getIntxVMFlag("TieredStopAtLevel");
        if (tieredCompilation != null && tieredCompilation.booleanValue() && compLevel != null && compLevel <= 3L) {
            return false;
        }
        return !Compiler.isGraalEnabled();
    }

    public static boolean isC1Enabled() {
        Boolean useCompiler = WB.getBooleanVMFlag("UseCompiler");
        if (useCompiler == null || !useCompiler.booleanValue()) {
            return false;
        }
        Boolean serverMode = WB.getBooleanVMFlag("ProfileInterpreter");
        if (serverMode == null || !serverMode.booleanValue()) {
            return true;
        }
        Boolean tieredCompilation = WB.getBooleanVMFlag("TieredCompilation");
        return tieredCompilation == null || tieredCompilation != false;
    }

    public static boolean isIntrinsicAvailable(int compLevel, String klass, String method, Class<?> ... parameterTypes) {
        Method intrinsicMethod;
        try {
            intrinsicMethod = Class.forName(klass).getDeclaredMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Test bug, '" + method + "' method unavailable. " + String.valueOf(e));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Test bug, '" + klass + "' class unavailable. " + String.valueOf(e));
        }
        return WB.isIntrinsicAvailable(intrinsicMethod, compLevel);
    }
}

