/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import jdk.test.lib.Utils;
import jdk.test.whitebox.WhiteBox;

public class CDSArchiveUtils {
    private static int genericHeaderMinVersion;
    private static int currentCDSArchiveVersion;
    private static int offsetMagic;
    private static int offsetCrc;
    private static int offsetVersion;
    private static int offsetHeaderSize;
    private static int offsetCommonAppClasspathPrefixSize;
    private static int offsetBaseArchiveNameOffset;
    private static int offsetBaseArchiveNameSize;
    private static int offsetJvmIdent;
    private static int spOffsetCrc;
    private static int spOffset;
    private static int spUsedOffset;
    private static int staticMagic;
    private static int dynamicMagic;
    private static int sizetSize;
    private static int intSize;
    private static int staticArchiveHeaderSize;
    private static int dynamicArchiveHeaderSize;
    private static int cdsFileMapRegionSize;
    private static long alignment;
    private static String[] shared_region_name;
    private static int num_regions;

    public static int getGenericHeaderMinVersion() {
        return genericHeaderMinVersion;
    }

    public static int getCurrentCDSArchiveVersion() {
        return currentCDSArchiveVersion;
    }

    public static int offsetMagic() {
        return offsetMagic;
    }

    public static int offsetCrc() {
        return offsetCrc;
    }

    public static int offsetVersion() {
        return offsetVersion;
    }

    public static int offsetHeaderSize() {
        return offsetHeaderSize;
    }

    public static int offsetCommonAppClasspathPrefixSize() {
        return offsetCommonAppClasspathPrefixSize;
    }

    public static int offsetBaseArchiveNameOffset() {
        return offsetBaseArchiveNameOffset;
    }

    public static int offsetBaseArchiveNameSize() {
        return offsetBaseArchiveNameSize;
    }

    public static int offsetJvmIdent() {
        return offsetJvmIdent;
    }

    public static int spOffsetCrc() {
        return spOffsetCrc;
    }

    public static int spOffset() {
        return spOffset;
    }

    public static int spUsedOffset() {
        return spUsedOffset;
    }

    public static int staticMagic() {
        return staticMagic;
    }

    public static int dynamicMagic() {
        return dynamicMagic;
    }

    public static int sizetSize() {
        return sizetSize;
    }

    public static int staticArchiveHeaderSize() {
        return staticArchiveHeaderSize;
    }

    public static int dynamicArchiveHeaderSize() {
        return dynamicArchiveHeaderSize;
    }

    public static int cdsFileMapRegionSize() {
        return cdsFileMapRegionSize;
    }

    public static long alignment() {
        return alignment;
    }

    public static int num_regions() {
        return num_regions;
    }

    public static long fileHeaderSize(File jsaFile) throws Exception {
        long headerSize = CDSArchiveUtils.readInt(jsaFile, offsetHeaderSize, 4);
        return headerSize;
    }

    public static long fileHeaderSizeAligned(File jsaFile) throws Exception {
        long size = CDSArchiveUtils.fileHeaderSize(jsaFile);
        return CDSArchiveUtils.alignUpWithAlignment(size);
    }

    public static int commonAppClasspathPrefixSize(File jsaFile) throws Exception {
        return (int)CDSArchiveUtils.readInt(jsaFile, offsetCommonAppClasspathPrefixSize, 4);
    }

    public static int baseArchiveNameOffset(File jsaFile) throws Exception {
        return (int)CDSArchiveUtils.readInt(jsaFile, offsetBaseArchiveNameOffset, 4);
    }

    public static int baseArchiveNameSize(File jsaFile) throws Exception {
        return (int)CDSArchiveUtils.readInt(jsaFile, offsetBaseArchiveNameSize, 4);
    }

    public static String baseArchiveName(File jsaFile) throws Exception {
        int size = CDSArchiveUtils.baseArchiveNameSize(jsaFile);
        int baseArchiveNameOffset = (int)CDSArchiveUtils.readInt(jsaFile, offsetBaseArchiveNameOffset, 4);
        return CDSArchiveUtils.readString(jsaFile, baseArchiveNameOffset, size - 1);
    }

    private static long alignUpWithAlignment(long l) {
        return l + alignment - 1L & (alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static void setReadWritePermission(File file) throws Exception {
        if (!file.canRead() && !file.setReadable(true)) {
            throw new IOException("Cannot modify file " + String.valueOf(file) + " as readable");
        }
        if (!file.canWrite() && !file.setWritable(true)) {
            throw new IOException("Cannot modify file " + String.valueOf(file) + " as writable");
        }
    }

    public static long getRandomBetween(long start, long end) throws Exception {
        if (start > end) {
            throw new IllegalArgumentException("start must be less than end");
        }
        Random aRandom = Utils.getRandomInstance();
        int d = aRandom.nextInt((int)(end - start));
        if (d < 1) {
            d = 1;
        }
        return start + (long)d;
    }

    public static void modifyContentRandomly(File jsaFile) throws Exception {
        long[] used = new long[num_regions];
        System.out.printf("%-24s%12s%12s%16s\n", "Space Name", "Used bytes", "Reg Start", "Random Offset");
        long start0 = CDSArchiveUtils.fileHeaderSizeAligned(jsaFile);
        for (int i = 0; i < num_regions; ++i) {
            used[i] = CDSArchiveUtils.usedRegionSizeAligned(jsaFile, i);
            long start = start0;
            for (int j = 0; j < i; ++j) {
                start += CDSArchiveUtils.alignUpWithAlignment(used[j]);
            }
            long end = start + used[i];
            if (start == end) continue;
            long offset = CDSArchiveUtils.getRandomBetween(start, end);
            System.out.printf("%-24s%12d%12d%16d\n", shared_region_name[i], used[i], start, offset);
            int bufSize = end - offset < 1024L ? (int)(end - offset + 1L) : 1024;
            CDSArchiveUtils.writeData(jsaFile, offset, new byte[bufSize]);
        }
    }

    public static void modifyRegionContentRandomly(File jsaFile) throws Exception {
        long[] used = new long[num_regions];
        System.out.printf("%-24s%12s%12s%16s\n", "Space Name", "Used bytes", "Reg Start", "Random Offset");
        long start0 = CDSArchiveUtils.fileHeaderSizeAligned(jsaFile);
        for (int i = 0; i < num_regions; ++i) {
            used[i] = CDSArchiveUtils.usedRegionSizeAligned(jsaFile, i);
            long start = start0;
            for (int j = 0; j < i; ++j) {
                start += CDSArchiveUtils.alignUpWithAlignment(used[j]);
            }
            long end = start + used[i];
            if (start == end) continue;
            long offset = CDSArchiveUtils.getRandomBetween(start, end);
            System.out.printf("%-24s%12d%12d%16d\n", shared_region_name[i], used[i], start, offset);
            int bufSize = end - offset < 1024L ? (int)(end - offset + 1L) : 1024;
            CDSArchiveUtils.writeData(jsaFile, offset, new byte[bufSize]);
        }
    }

    public static boolean modifyRegionContent(int region, File jsaFile) throws Exception {
        long total = 0L;
        long[] used = new long[num_regions];
        System.out.printf("%-24s%12s\n", "Space name", "Used bytes");
        for (int i = 0; i < num_regions; ++i) {
            used[i] = CDSArchiveUtils.usedRegionSizeAligned(jsaFile, i);
            System.out.printf("%-24s%12d\n", shared_region_name[i], used[i]);
            total += used[i];
        }
        if (used[region] == 0L) {
            System.out.println("Region " + shared_region_name[region] + " is empty. Nothing to corrupt.");
            return false;
        }
        byte[] buf = new byte[4096];
        System.out.printf("%-24s%12d\n", "Total: ", total);
        long regionStartOffset = CDSArchiveUtils.fileHeaderSizeAligned(jsaFile);
        for (int i = 0; i < region; ++i) {
            regionStartOffset += used[i];
        }
        System.out.println("Corrupt " + shared_region_name[region] + " section, start = " + regionStartOffset + " (header_size + 0x" + Long.toHexString(regionStartOffset - CDSArchiveUtils.fileHeaderSizeAligned(jsaFile)) + ")");
        for (long bytesWritten = 0L; bytesWritten < used[region]; bytesWritten += CDSArchiveUtils.writeData(jsaFile, regionStartOffset + bytesWritten, buf)) {
        }
        return true;
    }

    public static void modifyRegionCrc(File jsaFile, int region, int value) throws Exception {
        long regionCrcOffset = spOffset + region * spOffsetCrc;
        CDSArchiveUtils.writeData(jsaFile, regionCrcOffset, value);
    }

    public static void modifyAllRegionsCrc(File jsaFile) throws Exception {
        int value = -1159808322;
        long[] used = new long[num_regions];
        for (int i = 0; i < num_regions; ++i) {
            used[i] = CDSArchiveUtils.usedRegionSizeAligned(jsaFile, i);
            if (used[i] == 0L) continue;
            CDSArchiveUtils.modifyRegionCrc(jsaFile, i, value);
        }
    }

    public static void modifyFileHeader(File jsaFile) throws Exception {
        byte[] buf = new byte[(int)CDSArchiveUtils.fileHeaderSize(jsaFile)];
        CDSArchiveUtils.writeData(jsaFile, 0L, buf);
    }

    public static void modifyFileHeaderSize(File jsaFile, int newHeaderSize) throws Exception {
        CDSArchiveUtils.modifyHeaderIntField(jsaFile, offsetHeaderSize, newHeaderSize);
    }

    public static void modifyJvmIdent(File jsaFile, String newJvmIdent) throws Exception {
        byte[] buf = newJvmIdent.getBytes();
        CDSArchiveUtils.writeData(jsaFile, (long)offsetJvmIdent, buf);
    }

    public static void modifyHeaderIntField(File jsaFile, long offset, int value) throws Exception {
        CDSArchiveUtils.writeData(jsaFile, offset, value);
    }

    public static File copyArchiveFile(File orgJsaFile, String newName) throws Exception {
        File newJsaFile = new File(newName);
        if (newJsaFile.exists() && !newJsaFile.delete()) {
            throw new IOException("Could not delete file " + String.valueOf(newJsaFile));
        }
        Files.copy(orgJsaFile.toPath(), newJsaFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        CDSArchiveUtils.setReadWritePermission(newJsaFile);
        return newJsaFile;
    }

    public static File createMagicOnlyFile(String fileName, boolean createStatic) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(createStatic ? staticMagic : dynamicMagic);
            out.write(buffer.array(), 0, 4);
        }
        return file;
    }

    private static FileChannel getFileChannel(File file, boolean write) throws Exception {
        ArrayList<StandardOpenOption> arry = new ArrayList<StandardOpenOption>();
        arry.add(StandardOpenOption.READ);
        if (write) {
            arry.add(StandardOpenOption.WRITE);
        }
        return FileChannel.open(file.toPath(), new HashSet(arry), new FileAttribute[0]);
    }

    private static long readInt(File file, long offset, int nBytes) throws Exception {
        try (FileChannel fc = CDSArchiveUtils.getFileChannel(file, false);){
            ByteBuffer bb = ByteBuffer.allocate(nBytes).order(ByteOrder.nativeOrder());
            fc.position(offset);
            fc.read(bb);
            bb.rewind();
            long l = nBytes > 4 ? bb.getLong(0) : (long)bb.getInt(0);
            return l;
        }
    }

    private static String readString(File file, long offset, int nBytes) throws Exception {
        try (FileChannel fc = CDSArchiveUtils.getFileChannel(file, false);){
            byte[] arr;
            ByteBuffer bb = ByteBuffer.allocate(nBytes).order(ByteOrder.nativeOrder());
            fc.position(offset);
            fc.read(bb);
            for (byte i : arr = bb.flip().array()) {
                System.out.print((char)i);
            }
            System.out.println("");
            String string = new String(arr);
            return string;
        }
    }

    private static long writeData(FileChannel fc, long offset, ByteBuffer bb) throws Exception {
        fc.position(offset);
        return fc.write(bb);
    }

    public static long writeData(File file, long offset, byte[] array) throws Exception {
        try (FileChannel fc = CDSArchiveUtils.getFileChannel(file, true);){
            ByteBuffer bbuf = ByteBuffer.wrap(array);
            bbuf.order(ByteOrder.nativeOrder());
            long l = CDSArchiveUtils.writeData(fc, offset, bbuf);
            return l;
        }
    }

    public static long writeData(File file, long offset, int value) throws Exception {
        try (FileChannel fc = CDSArchiveUtils.getFileChannel(file, true);){
            ByteBuffer bbuf = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(value).rewind();
            long l = CDSArchiveUtils.writeData(fc, offset, bbuf);
            return l;
        }
    }

    private static void transferFrom(FileChannel inputChannel, FileChannel outputChannel, long offset, long length) throws Exception {
        long n;
        long position = offset;
        for (long count = length; count > 0L && inputChannel.position() < inputChannel.size(); count -= n) {
            n = outputChannel.transferFrom(inputChannel, position, count);
            if (n < 0L || n > count) {
                throw new RuntimeException("Incorrect transfer length n = " + n + " (expected 0 <= n <= " + length + ")");
            }
            position += n;
        }
    }

    public static File insertBytesRandomlyAfterHeader(File orgFile, String newFileName) throws Exception {
        long headerSize = CDSArchiveUtils.fileHeaderSize(orgFile);
        long dupSize = CDSArchiveUtils.getRandomBetween(0L, headerSize);
        File dstFile = new File(newFileName);
        try (FileChannel inputChannel = new FileInputStream(orgFile).getChannel();
             FileChannel outputChannel = new FileOutputStream(dstFile).getChannel();){
            long orgSize = inputChannel.size();
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, 0L, headerSize);
            inputChannel.position(headerSize - dupSize);
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, headerSize, orgSize - headerSize);
        }
        return dstFile;
    }

    public static File deleteBytesAtRandomPositionAfterHeader(File orgFile, String newFileName, int nBytes) throws Exception {
        long offset = CDSArchiveUtils.fileHeaderSize(orgFile) + CDSArchiveUtils.getRandomBetween(0L, 4096L);
        File dstFile = new File(newFileName);
        try (FileChannel inputChannel = new FileInputStream(orgFile).getChannel();
             FileChannel outputChannel = new FileOutputStream(dstFile).getChannel();){
            long orgSize = inputChannel.size();
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, 0L, offset);
            inputChannel.position(offset + (long)nBytes);
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, offset, orgSize - (long)nBytes);
        }
        return dstFile;
    }

    private static long getLastUsedRegionSize(File jsaFile) throws Exception {
        long regionSize = 0L;
        for (int i = num_regions - 1; i >= 0 && (regionSize = CDSArchiveUtils.usedRegionSizeAligned(jsaFile, i)) <= 0L; --i) {
        }
        return regionSize;
    }

    public static File deleteBytesAtTheEnd(File orgFile, String newFileName) throws Exception {
        long offset = CDSArchiveUtils.fileHeaderSize(orgFile);
        long bytesToDelete = CDSArchiveUtils.getLastUsedRegionSize(orgFile);
        File dstFile = new File(newFileName);
        try (FileChannel inputChannel = new FileInputStream(orgFile).getChannel();
             FileChannel outputChannel = new FileOutputStream(dstFile).getChannel();){
            long orgSize = inputChannel.size();
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, 0L, offset);
            inputChannel.position(offset);
            CDSArchiveUtils.transferFrom(inputChannel, outputChannel, offset, orgSize - bytesToDelete);
        }
        return dstFile;
    }

    public static long usedRegionSize(File archiveFile, int region) throws Exception {
        long offset = spOffset + cdsFileMapRegionSize * region + spUsedOffset;
        return CDSArchiveUtils.readInt(archiveFile, offset, sizetSize);
    }

    public static long usedRegionSizeAligned(File archiveFile, int region) throws Exception {
        long used = CDSArchiveUtils.usedRegionSize(archiveFile, region);
        return CDSArchiveUtils.alignUpWithAlignment(used);
    }

    static {
        WhiteBox wb;
        shared_region_name = new String[]{"rw", "ro", "bm", "hp"};
        num_regions = shared_region_name.length;
        try {
            wb = WhiteBox.getWhiteBox();
            genericHeaderMinVersion = wb.getCDSGenericHeaderMinVersion();
            currentCDSArchiveVersion = wb.getCurrentCDSVersion();
            offsetMagic = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_magic");
            offsetCrc = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_crc");
            offsetVersion = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_version");
            offsetHeaderSize = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_header_size");
            offsetCommonAppClasspathPrefixSize = wb.getCDSOffsetForName("FileMapHeader::_common_app_classpath_prefix_size");
            offsetBaseArchiveNameOffset = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_base_archive_name_offset");
            offsetBaseArchiveNameSize = wb.getCDSOffsetForName("GenericCDSFileMapHeader::_base_archive_name_size");
            offsetJvmIdent = wb.getCDSOffsetForName("FileMapHeader::_jvm_ident");
            spOffsetCrc = wb.getCDSOffsetForName("CDSFileMapRegion::_crc");
            spUsedOffset = wb.getCDSOffsetForName("CDSFileMapRegion::_used") - spOffsetCrc;
            spOffset = wb.getCDSOffsetForName("CDSFileMapHeaderBase::_regions[0]") - offsetMagic;
            staticMagic = wb.getCDSConstantForName("static_magic");
            dynamicMagic = wb.getCDSConstantForName("dynamic_magic");
            staticArchiveHeaderSize = wb.getCDSConstantForName("static_file_header_size");
            dynamicArchiveHeaderSize = wb.getCDSConstantForName("dynamic_archive_header_size");
            sizetSize = wb.getCDSConstantForName("size_t_size");
            intSize = wb.getCDSConstantForName("int_size");
            cdsFileMapRegionSize = wb.getCDSConstantForName("CDSFileMapRegion_size");
            alignment = wb.metaspaceSharedRegionAlignment();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        try {
            int nonExistOffset = wb.getCDSOffsetForName("FileMapHeader::_non_exist_offset");
            System.exit(-1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

