/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.format;

import jdk.test.lib.format.ArrayDiff;

public class Format {
    public static String asLiteral(char c) {
        StringBuilder sb = new StringBuilder();
        Format.appendCharToSb(c, sb);
        return sb.toString();
    }

    public static String escapeString(String src) {
        StringBuilder sb = new StringBuilder();
        src.chars().forEachOrdered(c -> Format.appendCharToSb((char)c, sb));
        return sb.toString();
    }

    public static String asLiteral(Object o) {
        if (o instanceof String) {
            return "\"" + Format.escapeString((String)o) + "\"";
        }
        if (o instanceof Character) {
            return Format.asLiteral(((Character)o).charValue());
        }
        if (o instanceof Byte) {
            return String.valueOf(o);
        }
        return Format.escapeString(String.valueOf(o));
    }

    public static String arrayDiff(Object first, Object second) {
        return ArrayDiff.of(first, second).format();
    }

    public static String arrayDiff(Object first, Object second, int width, int contextBefore) {
        return ArrayDiff.of(first, second, width, contextBefore).format();
    }

    public static String paddingForWidth(int width) {
        return " ".repeat(width);
    }

    private static void appendCharToSb(char c, StringBuilder sb) {
        if (c == '\n') {
            sb.append("\\n");
        } else if (c == '\r') {
            sb.append("\\r");
        } else if (c == '\\') {
            sb.append("\\\\");
        } else if (c == '\"') {
            sb.append("\\\"");
        } else if (c < ' ' || c > '~') {
            sb.append("\\u" + String.format("%04X", c));
        } else {
            sb.append(c);
        }
    }
}

