/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc.aarch64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.aarch64.ProcAARCH64ThreadContext;
import sun.jvm.hotspot.utilities.Assert;

public class ProcAARCH64Thread
implements ThreadProxy {
    private ProcDebugger debugger;
    private int id;

    public ProcAARCH64Thread(ProcDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    public ProcAARCH64Thread(ProcDebugger debugger, long id) {
        this.debugger = debugger;
        this.id = (int)id;
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        ProcAARCH64ThreadContext context = new ProcAARCH64ThreadContext(this.debugger);
        long[] regs = this.debugger.getThreadIntegerRegisterSet(this.id);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(regs.length == 33, "size mismatch");
        }
        for (int i = 0; i < regs.length; ++i) {
            context.setRegister(i, regs[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcAARCH64Thread)) {
            return false;
        }
        return ((ProcAARCH64Thread)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

