/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import java.nio.channels.SelectionKey;
import org.omg.CORBA.INTERNAL;

public abstract class EventHandlerBase
implements EventHandler {
    protected ORB orb;
    protected Work work;
    protected boolean useWorkerThreadForEvent;
    protected boolean useSelectThreadToWait;
    protected SelectionKey selectionKey;

    @Override
    public void setUseSelectThreadToWait(boolean bl) {
        this.useSelectThreadToWait = bl;
    }

    @Override
    public boolean shouldUseSelectThreadToWait() {
        return this.useSelectThreadToWait;
    }

    @Override
    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    @Override
    public void handleEvent() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent->: " + this);
        }
        this.getSelectionKey().interestOps(this.getSelectionKey().interestOps() & ~this.getInterestOps());
        if (this.shouldUseWorkerThreadForEvent()) {
            Exception exception = null;
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: addWork to pool: 0");
                }
                this.orb.getThreadPoolManager().getThreadPool(0).getWorkQueue(0).addWork(this.getWork());
            }
            catch (NoSuchThreadPoolException noSuchThreadPoolException) {
                exception = noSuchThreadPoolException;
            }
            catch (NoSuchWorkQueueException noSuchWorkQueueException) {
                exception = noSuchWorkQueueException;
            }
            if (exception != null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".handleEvent: " + exception);
                }
                INTERNAL iNTERNAL = new INTERNAL("NoSuchThreadPoolException");
                iNTERNAL.initCause(exception);
                throw iNTERNAL;
            }
        } else {
            if (this.orb.transportDebugFlag) {
                this.dprint(".handleEvent: doWork");
            }
            this.getWork().doWork();
        }
        if (this.orb.transportDebugFlag) {
            this.dprint(".handleEvent<-: " + this);
        }
    }

    @Override
    public boolean shouldUseWorkerThreadForEvent() {
        return this.useWorkerThreadForEvent;
    }

    @Override
    public void setUseWorkerThreadForEvent(boolean bl) {
        this.useWorkerThreadForEvent = bl;
    }

    @Override
    public void setWork(Work work) {
        this.work = work;
    }

    @Override
    public Work getWork() {
        return this.work;
    }

    private void dprint(String string) {
        ORBUtility.dprint("EventHandlerBase", string);
    }
}

