/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.jca.Providers;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;
import sun.security.util.KeyUtil;

public final class RSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_NONE = "NoPadding";
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final String PAD_OAEP_MGF1 = "OAEP";
    private int mode;
    private String paddingType = "PKCS1Padding";
    private RSAPadding padding;
    private AlgorithmParameterSpec spec = null;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private String oaepHashAlgorithm = "SHA-1";
    private SecureRandom random;

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!string.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + string);
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equalsIgnoreCase(PAD_NONE)) {
            this.paddingType = PAD_NONE;
        } else if (string.equalsIgnoreCase(PAD_PKCS1)) {
            this.paddingType = PAD_PKCS1;
        } else {
            String string2 = string.toLowerCase(Locale.ENGLISH);
            if (string2.equals("oaeppadding")) {
                this.paddingType = PAD_OAEP_MGF1;
            } else if (string2.startsWith("oaepwith") && string2.endsWith("andmgf1padding")) {
                this.paddingType = PAD_OAEP_MGF1;
                this.oaepHashAlgorithm = string.substring(8, string.length() - 14);
                if (Providers.getProviderList().getService("MessageDigest", this.oaepHashAlgorithm) == null) {
                    throw new NoSuchPaddingException("MessageDigest not available for " + string);
                }
            } else {
                throw new NoSuchPaddingException("Padding " + string + " not supported");
            }
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.spec != null && this.spec instanceof OAEPParameterSpec) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(PAD_OAEP_MGF1, SunJCE.getInstance());
                algorithmParameters.init(this.spec);
                return algorithmParameters;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Cannot find OAEP  AlgorithmParameters implementation in SunJCE provider");
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException("OAEPParameterSpec not supported");
            }
        }
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.init(n, key, secureRandom, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Wrong parameters");
            invalidKeyException.initCause(invalidAlgorithmParameterException);
            throw invalidKeyException;
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, secureRandom, algorithmParameterSpec);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null) {
            this.init(n, key, secureRandom, null);
        } else {
            try {
                OAEPParameterSpec oAEPParameterSpec = algorithmParameters.getParameterSpec(OAEPParameterSpec.class);
                this.init(n, key, secureRandom, oAEPParameterSpec);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("Wrong parameter");
                invalidAlgorithmParameterException.initCause(invalidParameterSpecException);
                throw invalidAlgorithmParameterException;
            }
        }
    }

    private void init(int n, Key key, SecureRandom secureRandom, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n2;
        boolean bl;
        switch (n) {
            case 1: 
            case 3: {
                bl = true;
                break;
            }
            case 2: 
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + n);
            }
        }
        RSAKey rSAKey = RSAKeyFactory.toRSAKey(key);
        if (key instanceof RSAPublicKey) {
            this.mode = bl ? 1 : 4;
            this.publicKey = (RSAPublicKey)key;
            this.privateKey = null;
        } else {
            this.mode = bl ? 3 : 2;
            this.privateKey = (RSAPrivateKey)key;
            this.publicKey = null;
        }
        this.outputSize = n2 = RSACore.getByteLength(rSAKey.getModulus());
        this.bufOfs = 0;
        if (this.paddingType == PAD_NONE) {
            if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.padding = RSAPadding.getInstance(3, n2, secureRandom);
            this.buffer = new byte[n2];
        } else if (this.paddingType == PAD_PKCS1) {
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof TlsRsaPremasterSecretParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Parameters not supported");
                }
                this.spec = algorithmParameterSpec;
                this.random = secureRandom;
            }
            int n3 = this.mode <= 2 ? 2 : 1;
            this.padding = RSAPadding.getInstance(n3, n2, secureRandom);
            if (bl) {
                int n4 = this.padding.getMaxDataSize();
                this.buffer = new byte[n4];
            } else {
                this.buffer = new byte[n2];
            }
        } else {
            if (this.mode == 3 || this.mode == 4) {
                throw new InvalidKeyException("OAEP cannot be used to sign or verify signatures");
            }
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong Parameters for OAEP Padding");
                }
                this.spec = algorithmParameterSpec;
            } else {
                this.spec = new OAEPParameterSpec(this.oaepHashAlgorithm, "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
            }
            this.padding = RSAPadding.getInstance(4, n2, secureRandom, (OAEPParameterSpec)this.spec);
            if (bl) {
                int n5 = this.padding.getMaxDataSize();
                this.buffer = new byte[n5];
            } else {
                this.buffer = new byte[n2];
            }
        }
    }

    private void update(byte[] byArray, int n, int n2) {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (n2 > this.buffer.length - this.bufOfs) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byte[] byArray3;
            switch (this.mode) {
                case 3: {
                    byArray = this.padding.pad(this.buffer, 0, this.bufOfs);
                    byArray2 = RSACore.rsa(byArray, this.privateKey, true);
                    break;
                }
                case 4: {
                    byArray3 = RSACore.convert(this.buffer, 0, this.bufOfs);
                    byArray = RSACore.rsa(byArray3, this.publicKey);
                    byArray2 = this.padding.unpad(byArray);
                    break;
                }
                case 1: {
                    byArray = this.padding.pad(this.buffer, 0, this.bufOfs);
                    byArray2 = RSACore.rsa(byArray, this.publicKey);
                    break;
                }
                case 2: {
                    byte[] byArray4 = RSACore.convert(this.buffer, 0, this.bufOfs);
                    byArray = RSACore.rsa(byArray4, this.privateKey, false);
                    byArray2 = this.padding.unpad(byArray);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Internal error");
                }
            }
            byArray3 = byArray2;
            return byArray3;
        }
        finally {
            Arrays.fill(this.buffer, 0, this.bufOfs, (byte)0);
            this.bufOfs = 0;
            if (byArray != null && byArray != this.buffer && byArray != byArray2) {
                Arrays.fill(byArray, (byte)0);
            }
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        this.update(byArray, n, n2);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        this.update(byArray, n, n2);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.update(byArray, n, n2);
        return this.doFinal();
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.outputSize > byArray2.length - n3) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(byArray, n, n2);
        byte[] byArray3 = this.doFinal();
        int n4 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray2, n3, n4);
        Arrays.fill(byArray3, (byte)0);
        return n4;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        try {
            if (byArray.length > this.buffer.length) {
                throw new InvalidKeyException("Key is too long for wrapping");
            }
            this.update(byArray, 0, byArray.length);
            try {
                byte[] byArray2 = this.doFinal();
                return byArray2;
            }
            catch (BadPaddingException badPaddingException) {
                throw new InvalidKeyException("Wrapping failed", badPaddingException);
            }
        }
        finally {
            Arrays.fill(byArray, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        boolean bl = string.equals("TlsRsaPremasterSecret");
        BadPaddingException badPaddingException = null;
        byte[] byArray2 = null;
        this.update(byArray, 0, byArray.length);
        try {
            byArray2 = this.doFinal();
        }
        catch (BadPaddingException badPaddingException2) {
            if (bl) {
                badPaddingException = badPaddingException2;
            }
            throw new InvalidKeyException("Unwrapping failed", badPaddingException2);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Unwrapping failed", illegalBlockSizeException);
        }
        try {
            if (bl) {
                if (!(this.spec instanceof TlsRsaPremasterSecretParameterSpec)) {
                    throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
                }
                byArray2 = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)this.spec).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)this.spec).getServerVersion(), this.random, byArray2, badPaddingException != null);
            }
            Key key = ConstructKeys.constructKey(byArray2, string, n);
            return key;
        }
        finally {
            if (byArray2 != null) {
                Arrays.fill(byArray2, (byte)0);
            }
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        RSAKey rSAKey = RSAKeyFactory.toRSAKey(key);
        return rSAKey.getModulus().bitLength();
    }
}

