/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import sun.net.httpserver.ServerImpl;

class SSLStreams {
    SSLContext sslctx;
    SocketChannel chan;
    ServerImpl server;
    SSLEngine engine;
    EngineWrapper wrapper;
    OutputStream os;
    InputStream is;
    Lock handshaking = new ReentrantLock();
    int app_buf_size;
    int packet_buf_size;

    SSLStreams(ServerImpl serverImpl, SSLContext sSLContext, SocketChannel socketChannel) throws IOException {
        this.server = serverImpl;
        this.sslctx = sSLContext;
        this.chan = socketChannel;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        this.engine = sSLContext.createSSLEngine(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        this.engine.setUseClientMode(false);
        HttpsConfigurator httpsConfigurator = serverImpl.getHttpsConfigurator();
        this.configureEngine(httpsConfigurator, inetSocketAddress);
        this.wrapper = new EngineWrapper(socketChannel, this.engine);
    }

    private void configureEngine(HttpsConfigurator httpsConfigurator, InetSocketAddress inetSocketAddress) {
        if (httpsConfigurator != null) {
            Parameters parameters = new Parameters(httpsConfigurator, inetSocketAddress);
            httpsConfigurator.configure(parameters);
            SSLParameters sSLParameters = parameters.getSSLParameters();
            if (sSLParameters != null) {
                this.engine.setSSLParameters(sSLParameters);
            } else {
                if (parameters.getCipherSuites() != null) {
                    try {
                        this.engine.setEnabledCipherSuites(parameters.getCipherSuites());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                this.engine.setNeedClientAuth(parameters.getNeedClientAuth());
                this.engine.setWantClientAuth(parameters.getWantClientAuth());
                if (parameters.getProtocols() != null) {
                    try {
                        this.engine.setEnabledProtocols(parameters.getProtocols());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void close() throws IOException {
        this.wrapper.close();
    }

    InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new InputStream();
        }
        return this.is;
    }

    OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new OutputStream();
        }
        return this.os;
    }

    SSLEngine getSSLEngine() {
        return this.engine;
    }

    void beginHandshake() throws SSLException {
        this.engine.beginHandshake();
    }

    private ByteBuffer allocate(BufType bufType) {
        return this.allocate(bufType, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer allocate(BufType bufType, int n) {
        assert (this.engine != null);
        SSLStreams sSLStreams = this;
        synchronized (sSLStreams) {
            int n2;
            if (bufType == BufType.PACKET) {
                if (this.packet_buf_size == 0) {
                    SSLSession sSLSession = this.engine.getSession();
                    this.packet_buf_size = sSLSession.getPacketBufferSize();
                }
                if (n > this.packet_buf_size) {
                    this.packet_buf_size = n;
                }
                n2 = this.packet_buf_size;
            } else {
                if (this.app_buf_size == 0) {
                    SSLSession sSLSession = this.engine.getSession();
                    this.app_buf_size = sSLSession.getApplicationBufferSize();
                }
                if (n > this.app_buf_size) {
                    this.app_buf_size = n;
                }
                n2 = this.app_buf_size;
            }
            return ByteBuffer.allocate(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer realloc(ByteBuffer byteBuffer, boolean bl, BufType bufType) {
        SSLStreams sSLStreams = this;
        synchronized (sSLStreams) {
            int n = 2 * byteBuffer.capacity();
            ByteBuffer byteBuffer2 = this.allocate(bufType, n);
            if (bl) {
                byteBuffer.flip();
            }
            byteBuffer2.put(byteBuffer);
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }

    public WrapperResult sendData(ByteBuffer byteBuffer) throws IOException {
        WrapperResult wrapperResult = null;
        while (byteBuffer.remaining() > 0) {
            wrapperResult = this.wrapper.wrapAndSend(byteBuffer);
            SSLEngineResult.Status status = wrapperResult.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return wrapperResult;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = wrapperResult.result.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(handshakeStatus);
        }
        return wrapperResult;
    }

    public WrapperResult recvData(ByteBuffer byteBuffer) throws IOException {
        WrapperResult wrapperResult = null;
        assert (byteBuffer.position() == 0);
        while (byteBuffer.position() == 0) {
            wrapperResult = this.wrapper.recvAndUnwrap(byteBuffer);
            byteBuffer = wrapperResult.buf != byteBuffer ? wrapperResult.buf : byteBuffer;
            SSLEngineResult.Status status = wrapperResult.result.getStatus();
            if (status == SSLEngineResult.Status.CLOSED) {
                this.doClosure();
                return wrapperResult;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = wrapperResult.result.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
            this.doHandshake(handshakeStatus);
        }
        byteBuffer.flip();
        return wrapperResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doClosure() throws IOException {
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            WrapperResult wrapperResult;
            SSLEngineResult.Status status;
            this.handshaking.lock();
            ByteBuffer byteBuffer = this.allocate(BufType.APPLICATION);
            do {
                byteBuffer.clear();
                byteBuffer.flip();
                wrapperResult = this.wrapper.wrapAndSendX(byteBuffer, true);
                handshakeStatus = wrapperResult.result.getHandshakeStatus();
            } while ((status = wrapperResult.result.getStatus()) != SSLEngineResult.Status.CLOSED && (status != SSLEngineResult.Status.OK || handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING));
        }
        finally {
            this.handshaking.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) throws IOException {
        try {
            this.handshaking.lock();
            ByteBuffer byteBuffer = this.allocate(BufType.APPLICATION);
            while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                WrapperResult wrapperResult = null;
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        Runnable runnable;
                        while ((runnable = this.engine.getDelegatedTask()) != null) {
                            runnable.run();
                        }
                    }
                    case NEED_WRAP: {
                        byteBuffer.clear();
                        byteBuffer.flip();
                        wrapperResult = this.wrapper.wrapAndSend(byteBuffer);
                        break;
                    }
                    case NEED_UNWRAP: {
                        byteBuffer.clear();
                        wrapperResult = this.wrapper.recvAndUnwrap(byteBuffer);
                        if (wrapperResult.buf != byteBuffer) {
                            byteBuffer = wrapperResult.buf;
                        }
                        assert (byteBuffer.position() == 0);
                        break;
                    }
                }
                handshakeStatus = wrapperResult.result.getHandshakeStatus();
            }
        }
        finally {
            this.handshaking.unlock();
        }
    }

    class OutputStream
    extends java.io.OutputStream {
        ByteBuffer buf;
        boolean closed = false;
        byte[] single = new byte[1];

        OutputStream() {
            this.buf = SSLStreams.this.allocate(BufType.APPLICATION);
        }

        @Override
        public void write(int n) throws IOException {
            this.single[0] = (byte)n;
            this.write(this.single, 0, 1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("output stream is closed");
            }
            while (n2 > 0) {
                int n3 = n2 > this.buf.capacity() ? this.buf.capacity() : n2;
                this.buf.clear();
                this.buf.put(byArray, n, n3);
                n2 -= n3;
                n += n3;
                this.buf.flip();
                WrapperResult wrapperResult = SSLStreams.this.sendData(this.buf);
                if (wrapperResult.result.getStatus() != SSLEngineResult.Status.CLOSED) continue;
                this.closed = true;
                if (n2 <= 0) continue;
                throw new IOException("output stream is closed");
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            WrapperResult wrapperResult = null;
            SSLStreams.this.engine.closeOutbound();
            this.closed = true;
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            this.buf.clear();
            while (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                wrapperResult = SSLStreams.this.wrapper.wrapAndSend(this.buf);
                handshakeStatus = wrapperResult.result.getHandshakeStatus();
            }
            assert (wrapperResult.result.getStatus() == SSLEngineResult.Status.CLOSED);
        }
    }

    class InputStream
    extends java.io.InputStream {
        ByteBuffer bbuf;
        boolean closed = false;
        boolean eof = false;
        boolean needData = true;
        byte[] single = new byte[1];

        InputStream() {
            this.bbuf = SSLStreams.this.allocate(BufType.APPLICATION);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("SSL stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            int n3 = 0;
            if (!this.needData) {
                n3 = this.bbuf.remaining();
                boolean bl = this.needData = n3 == 0;
            }
            if (this.needData) {
                this.bbuf.clear();
                WrapperResult wrapperResult = SSLStreams.this.recvData(this.bbuf);
                this.bbuf = wrapperResult.buf == this.bbuf ? this.bbuf : wrapperResult.buf;
                n3 = this.bbuf.remaining();
                if (n3 == 0) {
                    this.eof = true;
                    return -1;
                }
                this.needData = false;
            }
            if (n2 > n3) {
                n2 = n3;
            }
            this.bbuf.get(byArray, n, n2);
            return n2;
        }

        @Override
        public int available() throws IOException {
            return this.bbuf.remaining();
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void reset() throws IOException {
            throw new IOException("mark/reset not supported");
        }

        @Override
        public long skip(long l) throws IOException {
            int n;
            if (this.closed) {
                throw new IOException("SSL stream is closed");
            }
            if (this.eof) {
                return 0L;
            }
            int n2 = n;
            for (n = (int)l; n > 0; n -= this.bbuf.remaining()) {
                if (this.bbuf.remaining() >= n) {
                    this.bbuf.position(this.bbuf.position() + n);
                    return n2;
                }
                this.bbuf.clear();
                WrapperResult wrapperResult = SSLStreams.this.recvData(this.bbuf);
                this.bbuf = wrapperResult.buf == this.bbuf ? this.bbuf : wrapperResult.buf;
            }
            return n2;
        }

        @Override
        public void close() throws IOException {
            this.eof = true;
            SSLStreams.this.engine.closeInbound();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            int n = this.read(this.single, 0, 1);
            if (n <= 0) {
                return -1;
            }
            return this.single[0] & 0xFF;
        }
    }

    class EngineWrapper {
        SocketChannel chan;
        SSLEngine engine;
        Object wrapLock;
        Object unwrapLock;
        ByteBuffer unwrap_src;
        ByteBuffer wrap_dst;
        boolean closed = false;
        int u_remaining;

        EngineWrapper(SocketChannel socketChannel, SSLEngine sSLEngine) throws IOException {
            this.chan = socketChannel;
            this.engine = sSLEngine;
            this.wrapLock = new Object();
            this.unwrapLock = new Object();
            this.unwrap_src = SSLStreams.this.allocate(BufType.PACKET);
            this.wrap_dst = SSLStreams.this.allocate(BufType.PACKET);
        }

        void close() throws IOException {
        }

        WrapperResult wrapAndSend(ByteBuffer byteBuffer) throws IOException {
            return this.wrapAndSendX(byteBuffer, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult wrapAndSendX(ByteBuffer byteBuffer, boolean bl) throws IOException {
            if (this.closed && !bl) {
                throw new IOException("Engine is closed");
            }
            WrapperResult wrapperResult = new WrapperResult();
            Object object = this.wrapLock;
            synchronized (object) {
                SSLEngineResult.Status status;
                this.wrap_dst.clear();
                do {
                    wrapperResult.result = this.engine.wrap(byteBuffer, this.wrap_dst);
                    status = wrapperResult.result.getStatus();
                    if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                    this.wrap_dst = SSLStreams.this.realloc(this.wrap_dst, true, BufType.PACKET);
                } while (status == SSLEngineResult.Status.BUFFER_OVERFLOW);
                if (status == SSLEngineResult.Status.CLOSED && !bl) {
                    this.closed = true;
                    return wrapperResult;
                }
                if (wrapperResult.result.bytesProduced() > 0) {
                    int n;
                    this.wrap_dst.flip();
                    assert (n == wrapperResult.result.bytesProduced());
                    for (n = this.wrap_dst.remaining(); n > 0; n -= this.chan.write(this.wrap_dst)) {
                    }
                }
            }
            return wrapperResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WrapperResult recvAndUnwrap(ByteBuffer byteBuffer) throws IOException {
            boolean bl;
            SSLEngineResult.Status status = SSLEngineResult.Status.OK;
            WrapperResult wrapperResult = new WrapperResult();
            wrapperResult.buf = byteBuffer;
            if (this.closed) {
                throw new IOException("Engine is closed");
            }
            if (this.u_remaining > 0) {
                this.unwrap_src.compact();
                this.unwrap_src.flip();
                bl = false;
            } else {
                this.unwrap_src.clear();
                bl = true;
            }
            Object object = this.unwrapLock;
            synchronized (object) {
                do {
                    if (bl) {
                        int n;
                        while ((n = this.chan.read(this.unwrap_src)) == 0) {
                        }
                        if (n == -1) {
                            throw new IOException("connection closed for reading");
                        }
                        this.unwrap_src.flip();
                    }
                    wrapperResult.result = this.engine.unwrap(this.unwrap_src, wrapperResult.buf);
                    status = wrapperResult.result.getStatus();
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        if (this.unwrap_src.limit() == this.unwrap_src.capacity()) {
                            this.unwrap_src = SSLStreams.this.realloc(this.unwrap_src, false, BufType.PACKET);
                        } else {
                            this.unwrap_src.position(this.unwrap_src.limit());
                            this.unwrap_src.limit(this.unwrap_src.capacity());
                        }
                        bl = true;
                        continue;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        wrapperResult.buf = SSLStreams.this.realloc(wrapperResult.buf, true, BufType.APPLICATION);
                        bl = false;
                        continue;
                    }
                    if (status != SSLEngineResult.Status.CLOSED) continue;
                    this.closed = true;
                    wrapperResult.buf.flip();
                    return wrapperResult;
                } while (status != SSLEngineResult.Status.OK);
            }
            this.u_remaining = this.unwrap_src.remaining();
            return wrapperResult;
        }
    }

    static enum BufType {
        PACKET,
        APPLICATION;

    }

    class WrapperResult {
        SSLEngineResult result;
        ByteBuffer buf;

        WrapperResult() {
        }
    }

    class Parameters
    extends HttpsParameters {
        InetSocketAddress addr;
        HttpsConfigurator cfg;
        SSLParameters params;

        Parameters(HttpsConfigurator httpsConfigurator, InetSocketAddress inetSocketAddress) {
            this.addr = inetSocketAddress;
            this.cfg = httpsConfigurator;
        }

        @Override
        public InetSocketAddress getClientAddress() {
            return this.addr;
        }

        @Override
        public HttpsConfigurator getHttpsConfigurator() {
            return this.cfg;
        }

        @Override
        public void setSSLParameters(SSLParameters sSLParameters) {
            this.params = sSLParameters;
        }

        SSLParameters getSSLParameters() {
            return this.params;
        }
    }
}

