/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeJmp;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeJsr
extends BytecodeJmp {
    BytecodeJsr(Method method, int bci) {
        super(method, bci);
    }

    @Override
    public int getTargetBCI() {
        return this.bci() + this.javaShortAt(1);
    }

    public void verify() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isValid(), "check jsr");
        }
    }

    public boolean isValid() {
        return this.javaCode() == 168;
    }

    public static BytecodeJsr at(Method method, int bci) {
        BytecodeJsr b = new BytecodeJsr(method, bci);
        if (Assert.ASSERTS_ENABLED) {
            b.verify();
        }
        return b;
    }

    public static BytecodeJsr atCheck(Method method, int bci) {
        BytecodeJsr b = new BytecodeJsr(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeJsr at(BytecodeStream bcs) {
        return new BytecodeJsr(bcs.method(), bcs.bci());
    }
}

