/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.StubQueue;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.interpreter.InterpreterCodelet;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class Interpreter {
    private static AddressField codeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("AbstractInterpreter");
        codeField = type.getAddressField("_code");
    }

    public StubQueue getCode() {
        Address code = codeField.getValue();
        if (code == null) {
            return null;
        }
        return new StubQueue(code, InterpreterCodelet.class);
    }

    public boolean contains(Address pc) {
        return this.getCode().contains(pc);
    }

    public InterpreterCodelet getCodeletContaining(Address pc) {
        return (InterpreterCodelet)this.getCode().getStubContaining(pc);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Interpreter.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

