/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.fs.AbstractFileTypeDetector;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsNativeDispatcher;

public class RegistryFileTypeDetector
extends AbstractFileTypeDetector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String implProbeContentType(Path path) throws IOException {
        if (!(path instanceof Path)) {
            return null;
        }
        Path path2 = path.getFileName();
        if (path2 == null) {
            return null;
        }
        String string = path2.toString();
        int n = string.lastIndexOf(46);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n);
        NativeBuffer nativeBuffer = null;
        NativeBuffer nativeBuffer2 = null;
        try {
            nativeBuffer = WindowsNativeDispatcher.asNativeBuffer(string2);
            nativeBuffer2 = WindowsNativeDispatcher.asNativeBuffer("Content Type");
            String string3 = RegistryFileTypeDetector.queryStringValue(nativeBuffer.address(), nativeBuffer2.address());
            return string3;
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(path.toString());
            String string4 = null;
            return string4;
        }
        finally {
            nativeBuffer2.release();
            nativeBuffer.release();
        }
    }

    private static native String queryStringValue(long var0, long var2);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                System.loadLibrary("nio");
                return null;
            }
        });
    }
}

