/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.NumberFormatProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.Set;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class NumberFormatProviderImpl
extends NumberFormatProvider
implements AvailableLanguageTags {
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public NumberFormatProviderImpl(LocaleProviderAdapter.Type type, Set<String> set) {
        this.type = type;
        this.langtags = set;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.forType(this.type).getAvailableLocales();
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public NumberFormat getCurrencyInstance(Locale locale) {
        return this.getInstance(locale, 1);
    }

    @Override
    public NumberFormat getIntegerInstance(Locale locale) {
        return this.getInstance(locale, 4);
    }

    @Override
    public NumberFormat getNumberInstance(Locale locale) {
        return this.getInstance(locale, 0);
    }

    @Override
    public NumberFormat getPercentInstance(Locale locale) {
        return this.getInstance(locale, 2);
    }

    private NumberFormat getInstance(Locale locale, int n) {
        if (locale == null) {
            throw new NullPointerException();
        }
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.forType(this.type);
        String[] stringArray = localeProviderAdapter.getLocaleResources(locale).getNumberPatterns();
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        int n2 = n == 4 ? 0 : n;
        DecimalFormat decimalFormat = new DecimalFormat(stringArray[n2], decimalFormatSymbols);
        if (n == 4) {
            decimalFormat.setMaximumFractionDigits(0);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setParseIntegerOnly(true);
        } else if (n == 1) {
            NumberFormatProviderImpl.adjustForCurrencyDefaultFractionDigits(decimalFormat, decimalFormatSymbols);
        }
        return decimalFormat;
    }

    private static void adjustForCurrencyDefaultFractionDigits(DecimalFormat decimalFormat, DecimalFormatSymbols decimalFormatSymbols) {
        int n;
        Currency currency = decimalFormatSymbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(decimalFormatSymbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n = currency.getDefaultFractionDigits()) != -1) {
            int n2 = decimalFormat.getMinimumFractionDigits();
            if (n2 == decimalFormat.getMaximumFractionDigits()) {
                decimalFormat.setMinimumFractionDigits(n);
                decimalFormat.setMaximumFractionDigits(n);
            } else {
                decimalFormat.setMinimumFractionDigits(Math.min(n, n2));
                decimalFormat.setMaximumFractionDigits(n);
            }
        }
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

