/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthCacheValue;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetBooleanAction;

public abstract class AuthenticationInfo
extends AuthCacheValue
implements Cloneable {
    static final long serialVersionUID = -2588378268010453259L;
    public static final char SERVER_AUTHENTICATION = 's';
    public static final char PROXY_AUTHENTICATION = 'p';
    static final boolean serializeAuth = AccessController.doPrivileged(new GetBooleanAction("http.auth.serializeRequests"));
    protected transient PasswordAuthentication pw;
    private static HashMap<String, Thread> requests = new HashMap();
    char type;
    AuthScheme authScheme;
    String protocol;
    String host;
    int port;
    String realm;
    String path;
    String s1;
    String s2;

    @Override
    public PasswordAuthentication credentials() {
        return this.pw;
    }

    @Override
    public AuthCacheValue.Type getAuthType() {
        return this.type == 's' ? AuthCacheValue.Type.Server : AuthCacheValue.Type.Proxy;
    }

    @Override
    AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getProtocolScheme() {
        return this.protocol;
    }

    protected boolean useAuthCache() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean requestIsInProgress(String string) {
        if (!serializeAuth) {
            return false;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            Thread thread = Thread.currentThread();
            Thread thread2 = requests.get(string);
            if (thread2 == null) {
                requests.put(string, thread);
                return false;
            }
            if (thread2 == thread) {
                return false;
            }
            while (requests.containsKey(string)) {
                try {
                    requests.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void requestCompleted(String string) {
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            Thread thread = requests.get(string);
            if (thread != null && thread == Thread.currentThread()) {
                boolean bl;
                boolean bl2 = bl = requests.remove(string) != null;
                assert (bl);
            }
            requests.notifyAll();
        }
    }

    public AuthenticationInfo(char c, AuthScheme authScheme, String string, int n, String string2) {
        this.type = c;
        this.authScheme = authScheme;
        this.protocol = "";
        this.host = string.toLowerCase();
        this.port = n;
        this.realm = string2;
        this.path = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public AuthenticationInfo(char c, AuthScheme authScheme, URL uRL, String string) {
        this.type = c;
        this.authScheme = authScheme;
        this.protocol = uRL.getProtocol().toLowerCase();
        this.host = uRL.getHost().toLowerCase();
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = uRL.getDefaultPort();
        }
        this.realm = string;
        String string2 = uRL.getPath();
        this.path = string2.length() == 0 ? string2 : AuthenticationInfo.reducePath(string2);
    }

    static String reducePath(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n != -1) {
            if (n < n2) {
                return string.substring(0, n + 1);
            }
            return string;
        }
        return string;
    }

    static AuthenticationInfo getServerAuth(URL uRL) {
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        String string = "s:" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n;
        return AuthenticationInfo.getAuth(string, uRL);
    }

    static String getServerAuthKey(URL uRL, String string, AuthScheme authScheme) {
        int n = uRL.getPort();
        if (n == -1) {
            n = uRL.getDefaultPort();
        }
        String string2 = "s:" + (Object)((Object)authScheme) + ":" + uRL.getProtocol().toLowerCase() + ":" + uRL.getHost().toLowerCase() + ":" + n + ":" + string;
        return string2;
    }

    static AuthenticationInfo getServerAuth(String string) {
        AuthenticationInfo authenticationInfo = AuthenticationInfo.getAuth(string, null);
        if (authenticationInfo == null && AuthenticationInfo.requestIsInProgress(string)) {
            authenticationInfo = AuthenticationInfo.getAuth(string, null);
        }
        return authenticationInfo;
    }

    static AuthenticationInfo getAuth(String string, URL uRL) {
        if (uRL == null) {
            return (AuthenticationInfo)cache.get(string, null);
        }
        return (AuthenticationInfo)cache.get(string, uRL.getPath());
    }

    static AuthenticationInfo getProxyAuth(String string, int n) {
        String string2 = "p::" + string.toLowerCase() + ":" + n;
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string2, null);
        return authenticationInfo;
    }

    static String getProxyAuthKey(String string, int n, String string2, AuthScheme authScheme) {
        String string3 = "p:" + (Object)((Object)authScheme) + "::" + string.toLowerCase() + ":" + n + ":" + string2;
        return string3;
    }

    static AuthenticationInfo getProxyAuth(String string) {
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)cache.get(string, null);
        if (authenticationInfo == null && AuthenticationInfo.requestIsInProgress(string)) {
            authenticationInfo = (AuthenticationInfo)cache.get(string, null);
        }
        return authenticationInfo;
    }

    void addToCache() {
        String string = this.cacheKey(true);
        if (this.useAuthCache()) {
            cache.put(string, this);
            if (this.supportsPreemptiveAuthorization()) {
                cache.put(this.cacheKey(false), this);
            }
        }
        AuthenticationInfo.endAuthRequest(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endAuthRequest(String string) {
        if (!serializeAuth) {
            return;
        }
        HashMap<String, Thread> hashMap = requests;
        synchronized (hashMap) {
            AuthenticationInfo.requestCompleted(string);
        }
    }

    void removeFromCache() {
        cache.remove(this.cacheKey(true), this);
        if (this.supportsPreemptiveAuthorization()) {
            cache.remove(this.cacheKey(false), this);
        }
    }

    public abstract boolean supportsPreemptiveAuthorization();

    public String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    public abstract String getHeaderValue(URL var1, String var2);

    public abstract boolean setHeaders(HttpURLConnection var1, HeaderParser var2, String var3);

    public abstract boolean isAuthorizationStale(String var1);

    String cacheKey(boolean bl) {
        if (bl) {
            return this.type + ":" + (Object)((Object)this.authScheme) + ":" + this.protocol + ":" + this.host + ":" + this.port + ":" + this.realm;
        }
        return this.type + ":" + this.protocol + ":" + this.host + ":" + this.port;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pw = new PasswordAuthentication(this.s1, this.s2.toCharArray());
        this.s1 = null;
        this.s2 = null;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.s1 = this.pw.getUserName();
        this.s2 = new String(this.pw.getPassword());
        objectOutputStream.defaultWriteObject();
    }
}

