/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux;

import java.lang.reflect.Constructor;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.amd64.LinuxAMD64ThreadContext;
import sun.jvm.hotspot.debugger.linux.ia64.LinuxIA64ThreadContext;
import sun.jvm.hotspot.debugger.linux.sparc.LinuxSPARCThreadContext;
import sun.jvm.hotspot.debugger.linux.x86.LinuxX86ThreadContext;

class LinuxThreadContextFactory {
    LinuxThreadContextFactory() {
    }

    static ThreadContext createThreadContext(LinuxDebugger dbg) {
        String cpu = dbg.getCPU();
        if (cpu.equals("x86")) {
            return new LinuxX86ThreadContext(dbg);
        }
        if (cpu.equals("amd64")) {
            return new LinuxAMD64ThreadContext(dbg);
        }
        if (cpu.equals("ia64")) {
            return new LinuxIA64ThreadContext(dbg);
        }
        if (cpu.equals("sparc")) {
            return new LinuxSPARCThreadContext(dbg);
        }
        try {
            Class<?> tcc = Class.forName("sun.jvm.hotspot.debugger.linux." + cpu.toLowerCase() + ".Linux" + cpu.toUpperCase() + "ThreadContext");
            Constructor<?>[] ctcc = tcc.getConstructors();
            return (ThreadContext)ctcc[0].newInstance(dbg);
        }
        catch (Exception e) {
            throw new RuntimeException("cpu " + cpu + " is not yet supported");
        }
    }
}

