/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import sun.jvm.hotspot.oops.ArrayData;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.MethodData;

public class MultiBranchData
extends ArrayData {
    static final int defaultCountOffSet = 0;
    static final int defaultDisaplacementOffSet = 1;
    static final int caseArrayStart = 2;
    static final int relativeCountOffSet = 0;
    static final int relativeDisplacementOffSet = 1;
    static final int perCaseCellCount = 2;

    public MultiBranchData(DataLayout layout) {
        super(layout);
    }

    int numberOfCases() {
        int alen = this.arrayLen() - 2;
        return alen / 2;
    }

    int defaultCount() {
        return this.arrayUintAt(0);
    }

    int defaultDisplacement() {
        return this.arrayIntAt(1);
    }

    int countAt(int index) {
        return this.arrayUintAt(2 + index * 2 + 0);
    }

    int displacementAt(int index) {
        return this.arrayIntAt(2 + index * 2 + 1);
    }

    static int defaultCountOffset() {
        return MultiBranchData.arrayElementOffset(0);
    }

    static int defaultDisplacementOffset() {
        return MultiBranchData.arrayElementOffset(1);
    }

    static int caseCountOffset(int index) {
        return MultiBranchData.caseArrayOffset() + MultiBranchData.perCaseSize() * index + MultiBranchData.relativeCountOffset();
    }

    static int caseArrayOffset() {
        return MultiBranchData.arrayElementOffset(2);
    }

    static int perCaseSize() {
        return 2 * MethodData.cellSize;
    }

    static int relativeCountOffset() {
        return 0 * MethodData.cellSize;
    }

    static int relativeDisplacementOffset() {
        return 1 * MethodData.cellSize;
    }

    @Override
    public void printDataOn(PrintStream st) {
        this.printShared(st, "MultiBranchData");
        st.println("default_count(" + this.defaultCount() + ") displacement(" + this.defaultDisplacement() + ")");
        int cases = this.numberOfCases();
        for (int i = 0; i < cases; ++i) {
            this.tab(st);
            st.println("count(" + this.countAt(i) + ") displacement(" + this.displacementAt(i) + ")");
        }
    }
}

