/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.ArrayUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECParameters;
import sun.security.x509.AlgorithmId;

public final class ECPrivateKeyImpl
extends PKCS8Key
implements ECPrivateKey {
    private static final long serialVersionUID = 88695385615075129L;
    private BigInteger s;
    private byte[] arrayS;
    private ECParameterSpec params;

    public ECPrivateKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPrivateKeyImpl(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        this.makeEncoding(bigInteger);
    }

    ECPrivateKeyImpl(byte[] byArray, ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        this.arrayS = (byte[])byArray.clone();
        this.params = eCParameterSpec;
        this.makeEncoding(byArray);
    }

    private void makeEncoding(byte[] byArray) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            byte[] byArray2 = (byte[])byArray.clone();
            ArrayUtil.reverse(byArray2);
            derOutputStream.putOctetString(byArray2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    private void makeEncoding(BigInteger bigInteger) throws InvalidKeyException {
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(this.params));
        try {
            byte[] byArray = bigInteger.toByteArray();
            int n = (this.params.getOrder().bitLength() + 7) / 8;
            byte[] byArray2 = new byte[n];
            int n2 = Math.max(byArray.length - byArray2.length, 0);
            int n3 = Math.max(byArray2.length - byArray.length, 0);
            int n4 = Math.min(byArray.length, byArray2.length);
            System.arraycopy(byArray, n2, byArray2, n3, n4);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            derOutputStream.putOctetString(byArray2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public BigInteger getS() {
        if (this.s == null) {
            byte[] byArray = (byte[])this.arrayS.clone();
            ArrayUtil.reverse(byArray);
            this.s = new BigInteger(1, byArray);
        }
        return this.s;
    }

    public byte[] getArrayS() {
        if (this.arrayS == null) {
            byte[] byArray = this.getS().toByteArray();
            ArrayUtil.reverse(byArray);
            int n = (this.params.getOrder().bitLength() + 7) / 8;
            this.arrayS = new byte[n];
            int n2 = Math.min(n, byArray.length);
            System.arraycopy(byArray, 0, this.arrayS, 0, n2);
        }
        return (byte[])this.arrayS.clone();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            Object object;
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.data;
            int n = derInputStream2.getInteger();
            if (n != 1) {
                throw new IOException("Version must be 1");
            }
            byte[] byArray = derInputStream2.getOctetString();
            ArrayUtil.reverse(byArray);
            this.arrayS = byArray;
            while (derInputStream2.available() != 0) {
                object = derInputStream2.getDerValue();
                if (((DerValue)object).isContextSpecific((byte)0) || ((DerValue)object).isContextSpecific((byte)1)) continue;
                throw new InvalidKeyException("Unexpected value: " + object);
            }
            object = this.algid.getParameters();
            if (object == null) {
                throw new InvalidKeyException("EC domain parameters must be encoded in the algorithm identifier");
            }
            this.params = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid EC private key", iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException("Invalid EC private key", invalidParameterSpecException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("ECPrivateKeyImpl keys are not directly deserializable");
    }
}

