/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.logging.POASystemException;
import com.sun.corba.se.impl.protocol.LocalClientRequestDispatcherBase;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.oa.OADestroyed;
import com.sun.corba.se.spi.oa.OAInvocationInfo;
import com.sun.corba.se.spi.oa.ObjectAdapter;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.ForwardException;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;

public class POALocalCRDImpl
extends LocalClientRequestDispatcherBase {
    private ORBUtilSystemException wrapper;
    private POASystemException poaWrapper;

    public POALocalCRDImpl(ORB oRB, int n, IOR iOR) {
        super(oRB, n, iOR);
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.poaWrapper = POASystemException.get(oRB, "rpc.protocol");
    }

    private OAInvocationInfo servantEnter(ObjectAdapter objectAdapter) throws OADestroyed {
        objectAdapter.enter();
        OAInvocationInfo oAInvocationInfo = objectAdapter.makeInvocationInfo(this.objectId);
        this.orb.pushInvocationInfo(oAInvocationInfo);
        return oAInvocationInfo;
    }

    private void servantExit(ObjectAdapter objectAdapter) {
        try {
            objectAdapter.returnServant();
        }
        finally {
            objectAdapter.exit();
            this.orb.popInvocationInfo();
        }
    }

    @Override
    public ServantObject servant_preinvoke(Object object, String string, Class clazz) {
        ObjectAdapter objectAdapter = this.oaf.find(this.oaid);
        OAInvocationInfo oAInvocationInfo = null;
        try {
            oAInvocationInfo = this.servantEnter(objectAdapter);
            oAInvocationInfo.setOperation(string);
        }
        catch (OADestroyed oADestroyed) {
            return this.servant_preinvoke(object, string, clazz);
        }
        try {
            try {
                objectAdapter.getInvocationServant(oAInvocationInfo);
                if (!this.checkForCompatibleServant(oAInvocationInfo, clazz)) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                this.servantExit(objectAdapter);
                throw throwable;
            }
        }
        catch (ForwardException forwardException) {
            RuntimeException runtimeException = new RuntimeException("deal with this.");
            runtimeException.initCause(forwardException);
            throw runtimeException;
        }
        catch (ThreadDeath threadDeath) {
            throw this.wrapper.runtimeexception(threadDeath);
        }
        catch (Throwable throwable) {
            if (throwable instanceof SystemException) {
                throw (SystemException)throwable;
            }
            throw this.poaWrapper.localServantLookup(throwable);
        }
        if (!this.checkForCompatibleServant(oAInvocationInfo, clazz)) {
            this.servantExit(objectAdapter);
            return null;
        }
        return oAInvocationInfo;
    }

    @Override
    public void servant_postinvoke(Object object, ServantObject servantObject) {
        ObjectAdapter objectAdapter = this.orb.peekInvocationInfo().oa();
        this.servantExit(objectAdapter);
    }
}

