/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.CharLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.RangeListConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SizeLimit;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.StringPatternConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class StringValueConstraint
extends SubtypeConstraint {
    private final Set<String> values;

    public StringValueConstraint() {
        this.values = new TreeSet<String>();
    }

    public StringValueConstraint(String str) {
        this.values = new TreeSet<String>();
        this.values.add(str);
    }

    private StringValueConstraint(Set<String> values) {
        this.values = values;
    }

    @Override
    public SubtypeConstraint complement() {
        ErrorReporter.INTERNAL_ERROR((String)"invalid set operation");
        return null;
    }

    @Override
    public StringValueConstraint except(SubtypeConstraint other) {
        StringValueConstraint o = (StringValueConstraint)other;
        TreeSet<String> returnValue = new TreeSet<String>();
        for (String str : this.values) {
            if (o.values.contains(str)) continue;
            returnValue.add(str);
        }
        return new StringValueConstraint(returnValue);
    }

    @Override
    public TernaryBool isSubset(SubtypeConstraint other) {
        return this.except(other).isEmpty();
    }

    public StringValueConstraint setOperation(SubtypeConstraint other, boolean isUnion) {
        StringValueConstraint o = (StringValueConstraint)other;
        TreeSet<String> returnValue = new TreeSet<String>();
        if (isUnion) {
            returnValue.addAll(this.values);
            returnValue.addAll(o.values);
        } else {
            returnValue.addAll(this.values);
            returnValue.retainAll(o.values);
        }
        return new StringValueConstraint(returnValue);
    }

    @Override
    public StringValueConstraint intersection(SubtypeConstraint other) {
        return this.setOperation(other, false);
    }

    @Override
    public boolean isElement(Object o) {
        String str = (String)o;
        return this.values.contains(str);
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.values.isEmpty());
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        StringValueConstraint o = (StringValueConstraint)other;
        return TernaryBool.fromBool(this.values.equals(o.values));
    }

    @Override
    public TernaryBool isFull() {
        return TernaryBool.TFALSE;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        boolean needComma = false;
        for (String str : this.values) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append('\"');
            sb.append(str);
            sb.append('\"');
            needComma = true;
        }
        sb.append(')');
    }

    public StringValueConstraint remove(RangeListConstraint rangeConstraint, boolean ifElement) {
        switch (rangeConstraint.getLimitType()) {
            case SIZE: {
                TreeSet<String> returnValue = new TreeSet<String>();
                for (String str : this.values) {
                    if (rangeConstraint.isElement(new SizeLimit(str.length())) == ifElement) continue;
                    returnValue.add(str);
                }
                return new StringValueConstraint(returnValue);
            }
            case CHAR: {
                TreeSet<String> returnValue = new TreeSet<String>();
                for (String str : this.values) {
                    boolean allCharsAreElements = true;
                    for (int charIndex = 0; charIndex < str.length(); ++charIndex) {
                        if (rangeConstraint.isElement(new CharLimit(str.charAt(charIndex)))) continue;
                        allCharsAreElements = false;
                        break;
                    }
                    if (allCharsAreElements == ifElement) continue;
                    returnValue.add(str);
                }
                return new StringValueConstraint(returnValue);
            }
        }
        return this;
    }

    public StringValueConstraint remove(StringPatternConstraint patternConstraint, boolean ifElement) {
        return this;
    }

    @Override
    public StringValueConstraint union(SubtypeConstraint other) {
        return this.setOperation(other, true);
    }
}

