/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.brokenpartsanalyzers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.brokenpartsanalyzers.AssignmentHandler;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class ReferencesProcessor
extends AssignmentHandler {
    public ReferencesProcessor(Assignment assignment) {
        super(assignment);
    }

    public Set<String> computeReferences(Set<Reference> references) {
        HashSet<String> result = new HashSet<String>();
        for (Reference reference : references) {
            Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
            if (assignment == null || assignment.getIdentifier() == null) {
                if (reference.getId() == null) continue;
                result.add(reference.getId().getDisplayName());
                continue;
            }
            result.add(assignment.getIdentifier().getDisplayName());
        }
        return result;
    }

    public boolean containsErroneousReference(Set<Reference> references) {
        for (Reference reference : references) {
            if (reference.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
                return true;
            }
            Assignment assignment = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null);
            if (assignment != null) continue;
            return true;
        }
        return false;
    }
}

