/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.execute;

import java.util.Arrays;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.ExecuteSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteDataContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteDataLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteSectionDragSourceListener;
import org.eclipse.titan.designer.editors.configeditor.pages.execute.ExecuteSectionDropTargetListener;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class ExecuteSubPage {
    private Label totalExecuteElementsLabel;
    private Table executeElementsTable;
    private TableViewer executeElementsTableViewer;
    private Button add;
    private Button remove;
    private static final String[] COLUMN_NAMES = new String[]{"moduleName", "testcaseName"};
    private final ConfigEditor editor;
    private ExecuteSectionHandler executeSectionHandler;

    public ExecuteSubPage(ConfigEditor editor) {
        this.editor = editor;
    }

    void createExecuteSection(Composite parent, final ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setToggleColor(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        section.setText("Elements to be executed");
        section.setDescription("Specify the list of testcases and control parts to be executed for this configuration.\nUse drag&drop to change the order of elements.");
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        GridData gd = new GridData(1808);
        section.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        section.setClient((Control)client);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        client.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        this.executeElementsTable = toolkit.createTable(client, 66306);
        this.executeElementsTable.setEnabled(this.executeSectionHandler != null);
        TableColumn column = new TableColumn(this.executeElementsTable, 16384, 0);
        column.setText("Module name");
        column.setWidth(200);
        column.setMoveable(false);
        column = new TableColumn(this.executeElementsTable, 16384, 1);
        column.setText("Testcase name");
        column.setMoveable(false);
        column.setWidth(200);
        this.executeElementsTable.setHeaderVisible(true);
        this.executeElementsTable.setLinesVisible(true);
        gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 200;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.executeElementsTable.setLayoutData((Object)gd);
        Composite buttons = toolkit.createComposite(client);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(1026));
        this.add = toolkit.createButton(buttons, "Add...", 8);
        gd = new GridData(258);
        this.add.setLayoutData((Object)gd);
        this.add.setEnabled(this.executeSectionHandler != null);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExecuteSectionHandler.ExecuteItem newItem;
                if (ExecuteSubPage.this.executeSectionHandler == null) {
                    return;
                }
                if (ExecuteSubPage.this.executeSectionHandler.getLastSectionRoot() == null) {
                    ExecuteSubPage.this.createNewExecuteSection();
                }
                if ((newItem = ExecuteSubPage.this.createNewExecuteItem()) == null) {
                    return;
                }
                ConfigTreeNodeUtilities.addChild((ParseTree)ExecuteSubPage.this.executeSectionHandler.getLastSectionRoot(), (ParseTree)newItem.getRoot());
                ExecuteSubPage.this.executeSectionHandler.getExecuteitems().add(newItem);
                ExecuteSubPage.this.internalRefresh();
                ExecuteSubPage.this.executeElementsTable.select(ExecuteSubPage.this.executeSectionHandler.getExecuteitems().size() - 1);
                ExecuteSubPage.this.executeElementsTable.showSelection();
                ExecuteSubPage.this.editor.setDirty();
            }
        });
        this.remove = toolkit.createButton(buttons, "Remove", 8);
        gd = new GridData(258);
        this.remove.setLayoutData((Object)gd);
        this.remove.setEnabled(this.executeSectionHandler != null);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ExecuteSubPage.this.executeElementsTableViewer == null || ExecuteSubPage.this.executeSectionHandler == null) {
                    return;
                }
                ExecuteSubPage.this.removeSelectedExecuteItems();
                if (ExecuteSubPage.this.executeSectionHandler.getExecuteitems().isEmpty()) {
                    ExecuteSubPage.this.removeExecuteSection();
                }
                ExecuteSubPage.this.internalRefresh();
                ExecuteSubPage.this.editor.setDirty();
            }
        });
        this.totalExecuteElementsLabel = toolkit.createLabel(buttons, "Total: 0");
        gd = new GridData(258);
        this.totalExecuteElementsLabel.setLayoutData((Object)gd);
        this.executeElementsTableViewer = new TableViewer(this.executeElementsTable);
        this.executeElementsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.executeElementsTableViewer.setContentProvider((IContentProvider)new ExecuteDataContentProvider());
        this.executeElementsTableViewer.setLabelProvider((IBaseLabelProvider)new ExecuteDataLabelProvider());
        this.executeElementsTableViewer.setInput((Object)this.executeSectionHandler);
        this.executeElementsTableViewer.setColumnProperties(COLUMN_NAMES);
        this.executeElementsTableViewer.setCellEditors((CellEditor[])new TextCellEditor[]{new TextCellEditor((Composite)this.executeElementsTable), new TextCellEditor((Composite)this.executeElementsTable)});
        this.executeElementsTableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public String getValue(Object element, String property) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                ExecuteDataLabelProvider labelProvider = (ExecuteDataLabelProvider)ExecuteSubPage.this.executeElementsTableViewer.getLabelProvider();
                return labelProvider.getColumnText(element, columnIndex);
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = Arrays.asList(COLUMN_NAMES).indexOf(property);
                if (element != null && element instanceof TableItem && value instanceof String) {
                    ExecuteSectionHandler.ExecuteItem executeItem = (ExecuteSectionHandler.ExecuteItem)((TableItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            ConfigTreeNodeUtilities.setText((ParseTree)executeItem.getModuleName(), (String)((String)value).trim());
                            break;
                        }
                        case 1: {
                            ConfigTreeNodeUtilities.setText((ParseTree)executeItem.getTestcaseName(), (String)((String)value).trim());
                            break;
                        }
                    }
                    ExecuteSubPage.this.executeElementsTableViewer.refresh((Object)executeItem);
                    ExecuteSubPage.this.editor.setDirty();
                }
            }
        });
        this.executeElementsTableViewer.addDragSupport(3, new Transfer[]{ExecuteItemTransfer.getInstance()}, (DragSourceListener)new ExecuteSectionDragSourceListener(this, this.executeElementsTableViewer));
        this.executeElementsTableViewer.addDropSupport(19, new Transfer[]{ExecuteItemTransfer.getInstance()}, (DropTargetListener)new ExecuteSectionDropTargetListener(this.executeElementsTableViewer, this.editor));
    }

    private void internalRefresh() {
        this.add.setEnabled(this.executeSectionHandler != null);
        this.remove.setEnabled(this.executeSectionHandler != null);
        this.executeElementsTable.setEnabled(this.executeSectionHandler != null);
        this.executeElementsTableViewer.setInput((Object)this.executeSectionHandler);
        if (this.executeSectionHandler == null) {
            this.totalExecuteElementsLabel.setText("Total: 0");
        } else {
            this.totalExecuteElementsLabel.setText("Total: " + this.executeSectionHandler.getExecuteitems().size());
        }
    }

    public void refreshData(ExecuteSectionHandler executeSectionHandler) {
        this.executeSectionHandler = executeSectionHandler;
        if (this.executeElementsTableViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExecuteSubPage.this.internalRefresh();
                }
            });
        }
    }

    private void createNewExecuteSection() {
        if (this.executeSectionHandler == null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.executeSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[EXECUTE]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    private ExecuteSectionHandler.ExecuteItem createNewExecuteItem() {
        if (this.executeSectionHandler == null) {
            return null;
        }
        ExecuteSectionHandler.ExecuteItem item = new ExecuteSectionHandler.ExecuteItem();
        ParserRuleContext root = new ParserRuleContext();
        item.setRoot((ParseTree)root);
        AddedParseTree moduleName = new AddedParseTree("module_name");
        AddedParseTree testcaseName = new AddedParseTree("testcase_name");
        item.setModuleName((ParseTree)moduleName);
        item.setTestcaseName((ParseTree)testcaseName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)ConfigTreeNodeUtilities.createHiddenTokenNode((String)"\n"));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)moduleName);
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)new AddedParseTree("."));
        ConfigTreeNodeUtilities.addChild((ParseTree)root, (ParseTree)testcaseName);
        return item;
    }

    private void removeExecuteSection() {
        if (this.executeSectionHandler == null || this.executeSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.executeSectionHandler.getLastSectionRoot());
        this.executeSectionHandler.setLastSectionRoot(null);
    }

    public void removeSelectedExecuteItems() {
        if (this.executeSectionHandler == null || this.executeElementsTableViewer == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)this.executeElementsTableViewer.getSelection();
        for (ExecuteSectionHandler.ExecuteItem item : selection) {
            if (item == null) continue;
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.executeSectionHandler.getLastSectionRoot(), (ParseTree)item.getRoot());
            this.executeSectionHandler.getExecuteitems().remove(item);
        }
    }
}

