/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.organize;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.actions.DeclarationCollectionHelper;
import org.eclipse.titan.designer.editors.actions.OpenDeclarationLabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

class ImportSelectionDialog
implements Runnable {
    private final Reference reference;
    private final List<DeclarationCollectionHelper> collected;
    private Location selected;
    private final IResource source;

    public ImportSelectionDialog(Reference reference, List<DeclarationCollectionHelper> collected, IResource source) {
        this.reference = reference;
        this.collected = collected;
        this.selected = null;
        this.source = source;
    }

    @Override
    public void run() {
        OpenDeclarationLabelProvider labelProvider = new OpenDeclarationLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(new Shell(Display.getCurrent()), (ILabelProvider)labelProvider);
        dialog.setTitle("Add Import");
        dialog.setMessage("For the missing reference: " + this.reference.getDisplayName() + " in " + this.source.getProjectRelativePath().toString() + ".");
        dialog.setElements(this.collected.toArray());
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            this.selected = ((DeclarationCollectionHelper)dialog.getFirstResult()).location;
        }
    }

    public Location getSelected() {
        return this.selected;
    }
}

