/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.propertypages;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEncodingManager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ide.IDEEncoding;

public class SystemFilePropertyPage
extends SystemBasePropertyPage
implements SelectionListener {
    protected Label labelNamePrompt;
    protected Label labelTypePrompt;
    protected Label labelPathPrompt;
    protected Label labelSizePrompt;
    protected Label labelModifiedPrompt;
    protected Button cbReadonlyPrompt;
    protected Button cbHiddenPrompt;
    protected Label labelName;
    protected Label labelType;
    protected Label labelPath;
    protected Label labelSize;
    protected Label labelModified;
    protected Label labelReadable;
    protected Label labelWritable;
    protected Label labelHidden;
    protected Button defaultEncodingButton;
    protected Button otherEncodingButton;
    protected Combo otherEncodingCombo;
    protected String errorMessage;
    protected boolean initDone = false;
    protected boolean wasReadOnly = false;
    protected String prevEncoding;
    private boolean encodingFieldAdded = false;
    private String defaultEncoding = null;
    private boolean isValidBefore = true;

    protected Control createContentArea(Composite parent) {
        IRemoteFile file = this.getRemoteFile();
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.labelNamePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_NAME_LABEL, (String)SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelName = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelName.setToolTipText(SystemFileResources.RESID_PP_FILE_NAME_TOOLTIP);
        this.labelTypePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_TYPE_LABEL, (String)SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        this.labelType = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
        this.labelType.setToolTipText(SystemFileResources.RESID_PP_FILE_TYPE_TOOLTIP);
        if (!file.isRoot()) {
            this.labelPathPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_PATH_LABEL, (String)SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
            this.labelPath = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelPath.setToolTipText(SystemFileResources.RESID_PP_FILE_PATH_TOOLTIP);
        }
        if (!file.isDirectory()) {
            this.labelSizePrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_SIZE_LABEL, (String)SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
            this.labelSize = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelSize.setToolTipText(SystemFileResources.RESID_PP_FILE_SIZE_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.labelModifiedPrompt = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_LABEL, (String)SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
            this.labelModified = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"");
            this.labelModified.setToolTipText(SystemFileResources.RESID_PP_FILE_MODIFIED_TOOLTIP);
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_READONLY_LABEL, (String)SystemFileResources.RESID_PP_FILE_READONLY_TOOLTIP);
        }
        if (!file.isRoot()) {
            this.cbHiddenPrompt = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, null, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_LABEL, (String)SystemFileResources.RESID_PP_FILE_HIDDEN_TOOLTIP);
        }
        IRemoteFileSubSystem subSys = file.getParentRemoteFileSubSystem();
        IHost host = subSys.getHost();
        if (subSys.getSubSystemConfiguration().supportsEncoding(host)) {
            SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"", (int)2);
            Group encodingGroup = SystemWidgetHelpers.createGroupComposite((Composite)composite_prompts, (int)2, (String)SystemFileResources.RESID_PP_FILE_ENCODING_GROUP_LABEL);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1;
            data.grabExcessVerticalSpace = false;
            encodingGroup.setLayoutData((Object)data);
            SelectionAdapter defaultButtonSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateEncodingGroupState(SystemFilePropertyPage.this.defaultEncodingButton.getSelection());
                    SystemFilePropertyPage.this.updateValidState();
                }
            };
            IRemoteFile parentFile = file.getParentRemoteFile();
            this.defaultEncoding = parentFile == null ? file.getParentRemoteFileSubSystem().getRemoteEncoding() : parentFile.getEncoding();
            String defaultEncodingLabel = SystemFileResources.RESID_PP_FILE_ENCODING_DEFAULT_LABEL;
            int idx = defaultEncodingLabel.indexOf(37);
            if (idx != -1) {
                defaultEncodingLabel = String.valueOf(defaultEncodingLabel.substring(0, idx)) + this.defaultEncoding + defaultEncodingLabel.substring(idx + 2);
            }
            this.defaultEncodingButton = SystemWidgetHelpers.createRadioButton((Composite)encodingGroup, null, (String)defaultEncodingLabel, (String)SystemFileResources.RESID_PP_FILE_ENCODING_DEFAULT_TOOLTIP);
            data = new GridData();
            data.horizontalSpan = 2;
            this.defaultEncodingButton.setLayoutData((Object)data);
            this.defaultEncodingButton.addSelectionListener((SelectionListener)defaultButtonSelectionListener);
            Composite otherComposite = new Composite((Composite)encodingGroup, 0);
            GridLayout otherLayout = new GridLayout();
            otherLayout.numColumns = 2;
            otherLayout.marginWidth = 0;
            otherLayout.marginHeight = 0;
            otherComposite.setLayout((Layout)otherLayout);
            otherComposite.setLayoutData((Object)new GridData(32));
            this.otherEncodingButton = SystemWidgetHelpers.createRadioButton((Composite)otherComposite, null, (String)SystemFileResources.RESID_PP_FILE_ENCODING_OTHER_LABEL, (String)SystemFileResources.RESID_PP_FILE_ENCODING_OTHER_TOOLTIP);
            SelectionAdapter otherButtonSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateEncodingGroupState(!SystemFilePropertyPage.this.otherEncodingButton.getSelection());
                    SystemFilePropertyPage.this.updateValidState();
                }
            };
            this.otherEncodingButton.addSelectionListener((SelectionListener)otherButtonSelectionListener);
            this.otherEncodingCombo = SystemWidgetHelpers.createCombo((Composite)otherComposite, null, (String)SystemFileResources.RESID_PP_FILE_ENCODING_ENTER_TOOLTIP);
            data = new GridData();
            data.horizontalAlignment = 1;
            data.grabExcessHorizontalSpace = true;
            this.otherEncodingCombo.setLayoutData((Object)data);
            this.otherEncodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemFilePropertyPage.this.updateValidState();
                }
            });
            this.otherEncodingCombo.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    SystemFilePropertyPage.this.updateValidState();
                }
            });
            SystemWidgetHelpers.createLabel((Composite)encodingGroup, (String)"");
            SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"", (int)2);
            this.encodingFieldAdded = true;
        } else {
            this.encodingFieldAdded = false;
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        if (!file.isRoot() && file.showReadOnlyProperty()) {
            this.cbReadonlyPrompt.addSelectionListener((SelectionListener)this);
        }
        return composite_prompts;
    }

    private void updateEncodingGroupState(boolean useDefault) {
        this.defaultEncodingButton.setSelection(useDefault);
        this.otherEncodingButton.setSelection(!useDefault);
        if (useDefault) {
            this.otherEncodingCombo.setText(this.getDefaultEncoding());
        }
        this.otherEncodingCombo.setEnabled(!useDefault);
        this.updateValidState();
    }

    private void updateValidState() {
        boolean isValid = this.isEncodingValid();
        if (isValid != this.isValidBefore) {
            this.isValidBefore = isValid;
            if (this.isValidBefore) {
                this.clearErrorMessage();
            } else {
                this.setErrorMessage(FileResources.MESSAGE_ENCODING_NOT_SUPPORTED);
            }
        }
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    protected String getSelectedEncoding() {
        if (this.defaultEncodingButton != null && this.defaultEncodingButton.getSelection()) {
            return this.defaultEncoding;
        }
        if (this.otherEncodingCombo != null) {
            return this.otherEncodingCombo.getText();
        }
        return null;
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isEncodingValid(this.otherEncodingCombo.getText());
    }

    private boolean isEncodingValid(String encoding) {
        try {
            return Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    protected IRemoteFile getRemoteFile() {
        IAdaptable element = this.getElement();
        IRemoteFile file = (IRemoteFile)element;
        return file;
    }

    protected void doInitializeFields() {
        Date date;
        String path;
        this.initDone = true;
        IRemoteFile file = this.getRemoteFile();
        String name = file.getName();
        if (name.length() > 100) {
            String shortName = name.substring(0, 97).concat("...");
            this.labelName.setText(shortName);
        } else {
            this.labelName.setText(name);
        }
        if (file.isRoot()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_ROOT_VALUE);
        } else if (file.isDirectory()) {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FOLDER_VALUE);
        } else {
            this.labelType.setText(SystemFileResources.RESID_PP_FILE_TYPE_FILE_VALUE);
        }
        if (this.labelPath != null && (path = file.getParentPath()) != null) {
            this.labelPath.setText(file.getParentPath());
        }
        if (this.labelSize != null) {
            NumberFormat fmt = NumberFormat.getIntegerInstance();
            String formattedNumber = fmt.format(file.getLength());
            this.labelSize.setText(formattedNumber);
        }
        if (this.labelModified != null && (date = file.getLastModifiedDate()) != null) {
            DateFormat datefmt = DateFormat.getDateTimeInstance((int)1, (int)0);
            String formattedDate = datefmt.format(date);
            this.labelModified.setText(formattedDate);
        }
        if (file.showReadOnlyProperty() && this.cbReadonlyPrompt != null) {
            this.cbReadonlyPrompt.setSelection(!file.canWrite());
            boolean bl = this.wasReadOnly = !file.canWrite();
            if (file instanceof IVirtualRemoteFile) {
                this.cbReadonlyPrompt.setEnabled(false);
            }
        }
        if (this.cbHiddenPrompt != null) {
            this.cbHiddenPrompt.setSelection(file.isHidden());
            this.cbHiddenPrompt.setEnabled(false);
        }
        if (this.encodingFieldAdded) {
            String encoding;
            List encodings = IDEEncoding.getIDEEncodings();
            String[] encodingStrings = new String[encodings.size()];
            encodings.toArray(encodingStrings);
            this.otherEncodingCombo.setItems(encodingStrings);
            this.prevEncoding = encoding = file.getEncoding();
            if (encoding.equalsIgnoreCase(this.defaultEncoding)) {
                this.updateEncodingGroupState(true);
            } else {
                this.otherEncodingCombo.setText(encoding);
                this.updateEncodingGroupState(false);
            }
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        boolean readOnlySelected = this.cbReadonlyPrompt != null ? this.cbReadonlyPrompt.getSelection() : false;
        IRemoteFile remoteFile = this.getRemoteFile();
        if (ok && this.cbReadonlyPrompt != null && (readOnlySelected && !this.wasReadOnly || !readOnlySelected && this.wasReadOnly)) {
            try {
                boolean oldCanWrite = remoteFile.canWrite();
                remoteFile.getParentRemoteFileSubSystem().setReadOnly(remoteFile, readOnlySelected, (IProgressMonitor)new NullProgressMonitor());
                boolean updatedValue = remoteFile.canWrite();
                SystemEditableRemoteFile editable = new SystemEditableRemoteFile(remoteFile);
                if (editable.checkOpenInEditor() != -1) {
                    editable.setReadOnly(readOnlySelected);
                }
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                remoteFile.markStale(true);
                if (oldCanWrite == updatedValue) {
                    if (remoteFile.isDirectory()) {
                        sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile.getParentRemoteFile(), 85, (Object)remoteFile.getParentRemoteFile()));
                    } else {
                        sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 85, (Object)remoteFile));
                    }
                } else {
                    sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)remoteFile, 86, null));
                }
            }
            catch (RemoteFileIOException exc) {
                String msgDetails = NLS.bind((String)FileResources.FILEMSG_IO_ERROR_DETAILS, (Object)exc.getMessage());
                this.setMessage((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1002", 4, FileResources.FILEMSG_IO_ERROR, msgDetails));
            }
            catch (RemoteFileSecurityException exc) {
                String msgDetails = NLS.bind((String)FileResources.FILEMSG_SECURITY_ERROR_DETAILS, (Object)exc.getMessage());
                this.setMessage((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF1001", 4, FileResources.FILEMSG_SECURITY_ERROR, msgDetails));
            }
            catch (SystemMessageException e) {
                this.setMessage(e.getSystemMessage());
            }
        }
        String selectedEncoding = this.getSelectedEncoding();
        if (ok && this.encodingFieldAdded && this.prevEncoding != null && !this.prevEncoding.equals(selectedEncoding)) {
            IRemoteFile rfile = this.getRemoteFile();
            IRemoteFileSubSystem subsys = rfile.getParentRemoteFileSubSystem();
            String hostName = subsys.getHost().getHostName();
            RemoteFileEncodingManager mgr = RemoteFileEncodingManager.getInstance();
            if (this.defaultEncodingButton.getSelection()) {
                mgr.setEncoding(hostName, rfile.getAbsolutePath(), null);
            } else {
                mgr.setEncoding(hostName, rfile.getAbsolutePath(), this.getSelectedEncoding());
            }
            SystemEditableRemoteFile editable = new SystemEditableRemoteFile(remoteFile);
            if (editable.checkOpenInEditor() != -1) {
                IFile file = editable.getLocalResource();
                try {
                    file.setCharset(selectedEncoding, null);
                }
                catch (CoreException coreException) {}
            }
        }
        return ok;
    }

    protected boolean wantDefaultAndApplyButton() {
        return true;
    }

    protected void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        this.doInitializeFields();
    }

    protected boolean verifyPageContents() {
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
    }

    public void setVisible(boolean visible) {
        IRemoteFile file;
        if (visible && (file = this.getRemoteFile()).isStale()) {
            try {
                file = file.getParentRemoteFileSubSystem().getRemoteFileObject(file.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {}
            this.setElement((IAdaptable)file);
            this.performDefaults();
        }
        super.setVisible(visible);
    }
}

