/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteServerLauncher;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ServerLaunchType;
import org.eclipse.rse.core.subsystems.ServerLauncher;
import org.eclipse.rse.internal.core.RSECoreMessages;

public class RemoteServerLauncher
extends ServerLauncher
implements IRemoteServerLauncher {
    protected static final ServerLaunchType SERVER_LAUNCH_TYPE_EDEFAULT = ServerLaunchType.DAEMON_LITERAL;
    protected final String PROPERTY_SET_NAME = "Launcher Properties";
    private final String PROPERTY_SET_LABEL = RSECoreMessages.RESID_PROPERTYSET_LAUNCHER_PROPERTIES;
    protected final String KEY_DAEMON_PORT = "daemon.port";
    protected final String KEY_REXEC_PORT = "rexec.port";
    protected final String KEY_SERVER_LAUNCH_TYPE_NAME = "server.launch.type.name";
    protected final String KEY_SERVER_PATH = "server.path";
    protected final String KEY_SERVER_SCRIPT = "server.script";
    protected final String KEY_AUTODETECT_SSL = "autodetect.ssl";
    protected ServerLaunchType _serverLaunchType = SERVER_LAUNCH_TYPE_EDEFAULT;
    protected boolean _hasSetServerLaunchType = false;
    protected static final int REXEC_PORT_EDEFAULT = 512;
    protected int _rexecPort = 512;
    protected static final int DAEMON_PORT_EDEFAULT = 4075;
    protected int _daemonPort = 4075;
    protected static final String SERVER_PATH_EDEFAULT = null;
    protected String _serverPath = SERVER_PATH_EDEFAULT;
    protected static final String SERVER_SCRIPT_EDEFAULT = null;
    protected String _serverScript = SERVER_SCRIPT_EDEFAULT;
    protected static final String REMOTE_ATTRIBUTES_EDEFAULT = null;
    protected static final String RESTRICTED_TYPES_EDEFAULT = null;
    protected static final boolean AUTODETECT_SSL_EDEFAULT = true;
    protected boolean _autoDetectSSL = true;
    protected IPropertyType _serverLauncherEnumType;

    public RemoteServerLauncher(String name, IConnectorService connectorService) {
        super(name, connectorService);
    }

    public IPropertyType getServerLauncherPropertyType() {
        if (this._serverLauncherEnumType == null) {
            List<ServerLaunchType> values = Arrays.asList(this.getSupportedLauncherEnumTypes());
            String[] enumValues = new String[values.size()];
            int i = 0;
            while (i < values.size()) {
                ServerLaunchType type = values.get(i);
                enumValues[i] = type.getName();
                ++i;
            }
            this._serverLauncherEnumType = PropertyType.getEnumPropertyType(enumValues);
        }
        return this._serverLauncherEnumType;
    }

    protected ServerLaunchType[] getSupportedLauncherEnumTypes() {
        return new ServerLaunchType[]{ServerLaunchType.DAEMON_LITERAL, ServerLaunchType.REXEC_LITERAL, ServerLaunchType.RUNNING_LITERAL};
    }

    public void restoreFromProperties() {
        IPropertySet set = this.getPropertySet("Launcher Properties");
        if (set != null) {
            try {
                if (set instanceof ILabeledObject) {
                    ILabeledObject ps = (ILabeledObject)((Object)set);
                    ps.setLabel(this.PROPERTY_SET_LABEL);
                }
                IProperty launchTypeProperty = set.getProperty("server.launch.type.name");
                launchTypeProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_MEANS_LABEL);
                String launchTypeName = launchTypeProperty.getValue();
                this._serverLaunchType = ServerLaunchType.get(launchTypeName);
                IProperty daemonPortProperty = set.getProperty("daemon.port");
                boolean daemon = this._serverLaunchType == null || this._serverLaunchType.getType() == 0;
                daemonPortProperty.setEnabled(daemon);
                daemonPortProperty.setLabel(RSECoreMessages.RESID_CONNECTION_DAEMON_PORT_LABEL);
                try {
                    this._daemonPort = Integer.parseInt(daemonPortProperty.getValue());
                }
                catch (Exception exception) {
                    this._daemonPort = 4075;
                }
                IProperty autoDetectProperty = set.getProperty("autodetect.ssl");
                if (autoDetectProperty != null) {
                    boolean autoDetect = this._serverLaunchType == null || this._serverLaunchType.getType() == 1;
                    autoDetectProperty.setEnabled(autoDetect);
                    autoDetectProperty.setLabel(RSECoreMessages.RESID_SUBSYSTEM_AUTODETECT_LABEL);
                    this._autoDetectSSL = Boolean.valueOf(autoDetectProperty.getValue());
                }
                boolean usingRexec = this._serverLaunchType != null && this._serverLaunchType.getType() == 1;
                IProperty rexecPortProperty = set.getProperty("rexec.port");
                rexecPortProperty.setEnabled(usingRexec);
                rexecPortProperty.setLabel(RSECoreMessages.RESID_CONNECTION_PORT_LABEL);
                try {
                    this._rexecPort = Integer.parseInt(rexecPortProperty.getValue());
                }
                catch (Exception exception) {
                    this._rexecPort = 512;
                }
                IProperty serverPathProperty = set.getProperty("server.path");
                serverPathProperty.setEnabled(usingRexec);
                serverPathProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_PATH);
                this._serverPath = serverPathProperty.getValue();
                IProperty serverScriptProperty = set.getProperty("server.script");
                serverScriptProperty.setEnabled(usingRexec);
                serverScriptProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_INVOCATION);
                this._serverScript = serverScriptProperty.getValue();
                this._hasSetServerLaunchType = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveToProperties() {
        IPropertySet set = this.getPropertySet("Launcher Properties");
        if (set == null && (set = this.createPropertySet("Launcher Properties", this.getDescription())) instanceof ILabeledObject) {
            ((ILabeledObject)((Object)set)).setLabel(this.PROPERTY_SET_LABEL);
        }
        if (this._serverLaunchType == null) {
            this._serverLaunchType = ServerLaunchType.get(0);
        }
        IProperty launchTypeProperty = set.addProperty("server.launch.type.name", this._serverLaunchType.getName(), this.getServerLauncherPropertyType());
        launchTypeProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_MEANS_LABEL);
        IProperty daemonPortProperty = set.addProperty("daemon.port", "" + this._daemonPort, PropertyType.getIntegerPropertyType());
        daemonPortProperty.setEnabled(this._serverLaunchType.getType() == 0);
        daemonPortProperty.setLabel(RSECoreMessages.RESID_CONNECTION_DAEMON_PORT_LABEL);
        IProperty rexecPortProperty = set.addProperty("rexec.port", "" + this._rexecPort, PropertyType.getIntegerPropertyType());
        boolean usingRexec = this._serverLaunchType.getType() == 1;
        rexecPortProperty.setEnabled(usingRexec);
        rexecPortProperty.setLabel(RSECoreMessages.RESID_CONNECTION_PORT_LABEL);
        IProperty autoDetectSSLProperty = set.addProperty("autodetect.ssl", "" + this._autoDetectSSL, PropertyType.getBooleanPropertyType());
        autoDetectSSLProperty.setEnabled(usingRexec);
        autoDetectSSLProperty.setLabel(RSECoreMessages.RESID_SUBSYSTEM_AUTODETECT_LABEL);
        IProperty serverPathProperty = set.addProperty("server.path", this._serverPath);
        serverPathProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_PATH);
        serverPathProperty.setEnabled(usingRexec);
        IProperty serverScriptProperty = set.addProperty("server.script", this._serverScript);
        serverScriptProperty.setEnabled(usingRexec);
        serverScriptProperty.setLabel(RSECoreMessages.RESID_PROP_SERVERLAUNCHER_INVOCATION);
    }

    public IServerLauncherProperties cloneServerLauncher(IServerLauncherProperties newOne) {
        super.cloneServerLauncher(newOne);
        IRemoteServerLauncher remoteNewOne = (IRemoteServerLauncher)newOne;
        remoteNewOne.addPropertySets(this.getPropertySets());
        remoteNewOne.setDaemonPort(this.getDaemonPort());
        remoteNewOne.setRexecPort(this.getRexecPort());
        remoteNewOne.setServerLaunchType(this.getServerLaunchTypeGen());
        remoteNewOne.setServerPath(this.getServerPath());
        remoteNewOne.setServerScript(this.getServerScript());
        remoteNewOne.setAutoDetectSSL(this.getAutoDetectSSL());
        return remoteNewOne;
    }

    public ServerLaunchType getServerLaunchType() {
        if (!this.isSetServerLaunchType()) {
            if (this.isEnabledServerLaunchType(ServerLaunchType.DAEMON_LITERAL)) {
                return ServerLaunchType.DAEMON_LITERAL;
            }
            if (this.isEnabledServerLaunchType(ServerLaunchType.REXEC_LITERAL)) {
                return ServerLaunchType.REXEC_LITERAL;
            }
            if (this.isEnabledServerLaunchType(ServerLaunchType.RUNNING_LITERAL)) {
                return ServerLaunchType.RUNNING_LITERAL;
            }
            if (this.isEnabledServerLaunchType(ServerLaunchType.TELNET_LITERAL)) {
                return ServerLaunchType.TELNET_LITERAL;
            }
            if (this.isEnabledServerLaunchType(ServerLaunchType.SSH_LITERAL)) {
                return ServerLaunchType.SSH_LITERAL;
            }
            if (this.isEnabledServerLaunchType(ServerLaunchType.FTP_LITERAL)) {
                return ServerLaunchType.FTP_LITERAL;
            }
            return ServerLaunchType.HTTP_LITERAL;
        }
        return this._serverLaunchType;
    }

    public ServerLaunchType getServerLaunchTypeGen() {
        return this._serverLaunchType;
    }

    public void setServerLaunchType(ServerLaunchType newServerLaunchType) {
        ServerLaunchType oldServerLaunchType = this._serverLaunchType;
        if (oldServerLaunchType != newServerLaunchType) {
            this._serverLaunchType = newServerLaunchType == null ? SERVER_LAUNCH_TYPE_EDEFAULT : newServerLaunchType;
            this._hasSetServerLaunchType = true;
            this.setDirty(true);
        }
    }

    public boolean isSetServerLaunchType() {
        return this._hasSetServerLaunchType;
    }

    public int getRexecPort() {
        return this._rexecPort;
    }

    public void setRexecPort(int newRexecPort) {
        if (newRexecPort != this._rexecPort) {
            this._rexecPort = newRexecPort;
            this.setDirty(true);
        }
    }

    public boolean getAutoDetectSSL() {
        return this._autoDetectSSL;
    }

    public void setAutoDetectSSL(boolean auto) {
        if (auto != this._autoDetectSSL) {
            this._autoDetectSSL = auto;
            this.setDirty(true);
        }
    }

    public int getDaemonPort() {
        return this._daemonPort;
    }

    public void setDaemonPort(int newDaemonPort) {
        if (this._daemonPort != newDaemonPort) {
            this._daemonPort = newDaemonPort;
            this.setDirty(true);
        }
    }

    public String getServerPath() {
        String serverPath = this._serverPath;
        if (serverPath == null || serverPath.length() == 0) {
            serverPath = "/opt/rseserver/";
        }
        return serverPath;
    }

    public void setServerPath(String newServerPath) {
        String oldServerPath = this._serverPath;
        if (oldServerPath == null || !oldServerPath.equals(newServerPath)) {
            this._serverPath = newServerPath;
            this.setDirty(true);
        }
    }

    public String getServerScript() {
        String serverScript = this._serverScript;
        if (serverScript == null || serverScript.length() == 0) {
            serverScript = "server." + this.getConnectorService().getHost().getSystemType().getName().toLowerCase();
        }
        return serverScript;
    }

    public void setServerScript(String newServerScript) {
        String oldServerScript = this._serverScript;
        if (oldServerScript != newServerScript) {
            this._serverScript = newServerScript;
            this.setDirty(true);
        }
    }

    public boolean isEnabledServerLaunchType(ServerLaunchType serverLaunchType) {
        String value;
        IPropertySet set = this.getPropertySet("restrictedTypes");
        if (set != null && (value = set.getPropertyValue(serverLaunchType.getName())) != null) {
            return value.equals("true");
        }
        ISubSystem primarySS = this.getConnectorService().getPrimarySubSystem();
        if (primarySS != null) {
            return primarySS.getSubSystemConfiguration().supportsServerLaunchType(serverLaunchType);
        }
        return true;
    }

    public void setRestrictedType(String attributeName, String attributeValue) {
        IPropertySet set = this.getPropertySet("restrictedTypes");
        if (set == null) {
            set = this.createPropertySet("restrictedTypes", this.getDescription());
        }
        set.addProperty(attributeName, attributeValue);
    }

    public void enableServerLaunchType(ServerLaunchType serverLaunchType, boolean enable) {
    }
}

