/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LoggingOutputStream
extends FilterOutputStream {
    public LoggingOutputStream(OutputStream out) {
        super(out);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (Logger.isLogEnabled()) {
            Logger.log("Received " + len + " bytes: '" + Logger.encode(new String(b, 0, len)) + "'");
        }
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < len) {
            super.write(b[off + i]);
            ++i;
        }
    }

    public void write(int b) throws IOException {
        if (Logger.isLogEnabled()) {
            Logger.log("Received 1 bytes: '" + Logger.encode(new String(new byte[]{(byte)b}, 0, 1)) + "'");
        }
        super.write(b);
    }
}

