/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.FileSystemElement;
import org.eclipse.rse.internal.importexport.files.FileSystemStructureProvider;
import org.eclipse.rse.internal.importexport.files.IImportStructureProvider;
import org.eclipse.rse.internal.importexport.files.MinimizedFileSystemElement;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportOperation;
import org.eclipse.rse.internal.importexport.files.RemoteImportWizard;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.SynchronizeData;
import org.eclipse.rse.internal.synchronize.provisional.SynchronizeOperation;
import org.eclipse.rse.internal.synchronize.provisional.Synchronizer;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.messages.SystemMessageLine;
import org.eclipse.rse.ui.wizards.ISystemWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;

class RemoteImportWizardPage1
extends WizardResourceImportPage
implements Listener,
ISystemWizardPage {
    private Object sourceDirectory = null;
    private String helpId;
    private Composite parentComposite;
    private SystemMessageLine msgLine;
    private SystemMessage pendingMessage;
    private SystemMessage pendingErrorMessage;
    private String pendingString;
    private String pendingErrorString;
    protected Composite sourceComposite;
    protected Combo sourceNameField;
    protected Button reviewSynchronizeCheckbox;
    protected Button overwriteExistingResourcesCheckbox;
    protected Button createContainerStructureButton;
    protected Button createOnlySelectedButton;
    protected Button saveSettingsButton;
    protected Label descFilePathLabel;
    protected Text descFilePathField;
    protected Button descFileBrowseButton;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private QueryAllJob _queryAllJob;
    private MinimizedFileSystemElement _fileSystemTree;
    protected Object inputObject = null;
    protected boolean initSourceNameSet = false;
    private static final String STORE_SOURCE_NAMES_ID = "RemoteImportWizardPage1.STORE_SOURCE_NAMES_ID";
    private static final String STORE_REVIEW_SYNCHRONIZE_ID = "RemoteImportWizardPage1.STORE_REVIEW_SYNCHRONIZE_ID";
    private static final String STORE_OVERWRITE_EXISTING_RESOURCES_ID = "RemoteImportWizardPage1.STORE_OVERWRITE_EXISTING_RESOURCES_ID";
    private static final String STORE_CREATE_CONTAINER_STRUCTURE_ID = "RemoteImportWizardPage1.STORE_CREATE_CONTAINER_STRUCTURE_ID";
    private static final String STORE_CREATE_DESCRIPTION_FILE_ID = "RemoteImportWizardPage1.STORE_CREATE_DESCRIPTION_FILE_ID";
    private static final String STORE_DESCRIPTION_FILE_NAME_ID = "RemoteImportWizardPage1.STORE_DESCRIPTION_FILE_NAME_ID";
    protected static final SystemMessage SOURCE_EMPTY_MESSAGE = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8066", 4, RemoteImportExportResources.FILEMSG_SOURCE_EMPTY, RemoteImportExportResources.FILEMSG_SOURCE_EMPTY_DETAILS);

    protected RemoteImportWizardPage1(String name, IWorkbench aWorkbench, IStructuredSelection selection) {
        super(name, selection);
        this.setInputObject(selection);
    }

    public RemoteImportWizardPage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        this("fileSystemImportPage1", aWorkbench, selection);
        this.setTitle(SystemImportExportResources.RESID_FILEIMPORT_PAGE1_TITLE);
        this.setDescription(SystemImportExportResources.RESID_FILEIMPORT_PAGE1_DESCRIPTION);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = SystemWidgetHelpers.createComposite((Composite)parent, (int)3);
        ((GridLayout)buttonComposite.getLayout()).makeColumnsEqualWidth = true;
        this.selectTypesButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, null, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_SELECTTYPES_LABEL, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_SELECTTYPES_TOOLTIP);
        this.selectAllButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, null, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_SELECTALL_LABEL, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_SELECTALL_TOOLTIP);
        this.deselectAllButton = SystemWidgetHelpers.createPushButton((Composite)buttonComposite, null, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_DESELECTALL_LABEL, (String)SystemImportExportResources.RESID_FILEIMPEXP_BUTTON_DESELECTALL_TOOLTIP);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteImportWizardPage1.this.handleTypesEditButtonPressed();
            }
        };
        this.selectTypesButton.addSelectionListener((SelectionListener)listener);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteImportWizardPage1.this.setAllSelections(true);
            }
        };
        this.selectAllButton.addSelectionListener((SelectionListener)listener);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteImportWizardPage1.this.setAllSelections(false);
            }
        };
        this.deselectAllButton.addSelectionListener((SelectionListener)listener);
    }

    public void createControl(Composite parent) {
        this.parentComposite = new Composite(parent, 0);
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.parentComposite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        super.createControl(this.parentComposite);
        this.msgLine = new SystemMessageLine(this.parentComposite);
        this.msgLine.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.pendingMessage != null) {
            this.setMessage(this.pendingMessage);
        }
        if (this.pendingErrorMessage != null) {
            this.setErrorMessage(this.pendingErrorMessage);
        }
        if (this.pendingString != null) {
            this.setMessage(this.pendingString);
        }
        if (this.pendingErrorString != null) {
            this.setErrorMessage(this.pendingErrorString);
        }
        this.validateSourceGroup();
        if (!this.initSourceNameSet) {
            this.sourceNameField.setFocus();
        } else {
            this.selectionGroup.setFocus();
        }
        SystemWidgetHelpers.setWizardPageMnemonics((Composite)this.parentComposite);
        if (this.helpId != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)this.helpId);
        } else {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)"org.eclipse.rse.importexport.import_context");
        }
        this.setControl((Control)this.parentComposite);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.reviewSynchronizeCheckbox = SystemWidgetHelpers.createCheckBox((Composite)optionsGroup, (int)1, null, (String)SystemImportExportResources.RESID_FILEIMPORT_REVIEW_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_REVIEW_TOOLTIP);
        this.reviewSynchronizeCheckbox.addListener(13, (Listener)this);
        this.overwriteExistingResourcesCheckbox = SystemWidgetHelpers.createCheckBox((Composite)optionsGroup, (int)1, null, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_OVERWRITE_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_OVERWRITE_TOOLTIP);
        this.createContainerStructureButton = SystemWidgetHelpers.createRadioButton((Composite)optionsGroup, null, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_CREATEALL_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_CREATEALL_TOOLTIP);
        this.createOnlySelectedButton = SystemWidgetHelpers.createRadioButton((Composite)optionsGroup, null, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_CREATESEL_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_CREATESEL_TOOLTIP);
        this.createOnlySelectedButton.setSelection(true);
        Composite comp = SystemWidgetHelpers.createComposite((Composite)optionsGroup, (int)3);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.saveSettingsButton = SystemWidgetHelpers.createCheckBox((Composite)comp, (int)3, null, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_TOOLTIP);
        this.saveSettingsButton.addListener(13, (Listener)this);
        this.descFilePathLabel = new Label(comp, 0);
        this.descFilePathLabel.setText(SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_DESCFILE_LABEL);
        GridData data = new GridData();
        this.descFilePathLabel.setLayoutData((Object)data);
        this.descFilePathField = new Text(comp, 2052);
        this.descFilePathField.setToolTipText(SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_DESCFILE_PATH_TOOLTIP);
        data = new GridData();
        data.horizontalAlignment = 256;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this.descFilePathField.setLayoutData((Object)data);
        this.descFilePathField.addListener(24, (Listener)this);
        this.descFileBrowseButton = SystemWidgetHelpers.createPushButton((Composite)comp, null, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_DESCFILE_BROWSE_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_OPTION_SETTINGS_DESCFILE_BROWSE_TOOLTIP);
        this.descFileBrowseButton.addListener(13, (Listener)this);
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = SystemWidgetHelpers.createComposite((Composite)parent, (int)3);
        ((GridData)sourceContainerGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        this.sourceNameField = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)sourceContainerGroup, null, (String)SystemImportExportResources.RESID_FILEIMPORT_SOURCE_LABEL, (String)SystemImportExportResources.RESID_FILEIMPORT_SOURCE_TOOLTIP);
        ((GridData)this.sourceNameField.getLayoutData()).widthHint = 250;
        ((GridData)this.sourceNameField.getLayoutData()).grabExcessHorizontalSpace = true;
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteImportWizardPage1.this.updateFromSourceField();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                RemoteImportWizardPage1.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (RemoteImportWizardPage1.this.entryChanged) {
                    RemoteImportWizardPage1.this.entryChanged = false;
                    RemoteImportWizardPage1.this.updateFromSourceField();
                }
            }
        });
        this.sourceBrowseButton = SystemWidgetHelpers.createPushButton((Composite)sourceContainerGroup, null, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_BROWSE_LABEL, (String)SystemImportExportResources.RESID_FILEEXPORT_DESTINATION_BROWSE_TOOLTIP);
        ((GridData)this.sourceBrowseButton.getLayoutData()).grabExcessHorizontalSpace = false;
        this.sourceBrowseButton.addListener(13, (Listener)this);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        if (this._queryAllJob == null) {
            this._queryAllJob = new QueryAllJob(fileSystemObject, provider, result);
            this._queryAllJob.schedule();
        }
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.sourceComposite = parent;
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectTypesButton.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (((File)this.sourceDirectory).isDirectory()) {
            return true;
        }
        String msgTxt = RemoteImportExportResources.FILEMSG_FOLDER_IS_FILE;
        String msgDetails = NLS.bind((String)RemoteImportExportResources.FILEMSG_FOLDER_IS_FILE_DETAILS, (Object)((File)this.sourceDirectory).getAbsolutePath());
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8061", 4, msgTxt, msgDetails);
        this.setErrorMessage((SystemMessage)msg);
        this.sourceNameField.setFocus();
        return false;
    }

    protected boolean executeImportOperation(RemoteFileImportOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            if (status.isMultiStatus() && ((MultiStatus)status).getChildren().length > 0) {
                status = ((MultiStatus)status).getChildren()[0];
            }
            String msgTxt = NLS.bind((String)RemoteImportExportResources.MSG_IMPORT_EXPORT_UNEXPECTED_EXCEPTION, (Object)status.getMessage());
            SimpleSystemMessage msg = null;
            msg = status.getException() != null ? new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8070", 4, msgTxt, status.getException()) : new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8070", 4, msgTxt);
            SystemMessageDialog dlg = new SystemMessageDialog(this.getContainer().getShell(), (SystemMessage)msg);
            dlg.openWithDetails();
            return false;
        }
        return true;
    }

    public boolean finish() {
        this.clearMessage();
        this.clearErrorMessage();
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.getSelectedResources().iterator();
        ArrayList<Object> fileSystemObjects = new ArrayList<Object>();
        IHost conn = Utilities.parseForSystemConnection(this.sourceNameField.getText());
        while (resourcesEnum.hasNext()) {
            Object fo = ((FileSystemElement)resourcesEnum.next()).getFileSystemObject();
            String temp = ((File)fo).getAbsolutePath();
            Object file = UniFilePlus.class.isInstance(fo) ? fo : new UniFilePlus(Utilities.getIRemoteFile(conn, temp));
            fileSystemObjects.add(file);
        }
        if (fileSystemObjects.size() > 0) {
            RemoteFileImportData data = new RemoteFileImportData();
            data.setContainerPath(this.getContainerFullPath());
            data.setSource(this.getSourceDirectory());
            data.setElements(fileSystemObjects);
            data.setOverWriteExistingFiles(this.overwriteExistingResourcesCheckbox.getSelection());
            data.setCreateDirectoryStructure(this.createContainerStructureButton.getSelection());
            data.setCreateSelectionOnly(this.createOnlySelectedButton.getSelection());
            data.setSaveSettings(this.saveSettingsButton.getSelection());
            data.setDescriptionFilePath(this.getDescriptionLocation());
            if (!this.reviewSynchronizeCheckbox.getSelection()) {
                boolean ret = this.executeImportOperation(new RemoteFileImportOperation(data, FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this));
                return ret;
            }
            SynchronizeData data2 = null;
            try {
                data2 = new SynchronizeData(data);
            }
            catch (SystemMessageException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (this.reviewSynchronizeCheckbox.getSelection()) {
                data2.setSynchronizeType(5);
            }
            boolean ret = false;
            try {
                ret = new Synchronizer(data2).run(new SynchronizeOperation());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (data.isSaveSettings()) {
                    RSESyncUtils.saveDescription(data);
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return ret;
        }
        String msgTxt = RemoteImportExportResources.FILEMSG_IMPORT_NONE_SELECTED;
        String msgDetails = RemoteImportExportResources.FILEMSG_IMPORT_NONE_SELECTED_DETAILS;
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF8071", 4, msgTxt, msgDetails);
        this.setErrorMessage((SystemMessage)msg);
        return false;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){
            boolean busy = false;

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement && !this.busy) {
                    final MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    final Object[] oa = new Object[1];
                    this.busy = true;
                    BusyIndicator.showWhile((Display)RemoteImportWizardPage1.this.sourceComposite.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            oa[0] = element.getFiles(FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                        }
                    });
                    this.busy = false;
                    return (Object[])oa[0];
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        if (this._fileSystemTree == null) {
            this._fileSystemTree = this.selectFiles(sourceDirectory, FileSystemStructureProvider.INSTANCE);
        }
        return this._fileSystemTree;
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){
            boolean busy = false;

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement && !this.busy) {
                    final MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    final Object[] oa = new Object[1];
                    this.busy = true;
                    BusyIndicator.showWhile((Display)RemoteImportWizardPage1.this.sourceComposite.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            oa[0] = element.getFolders(FileSystemStructureProvider.INSTANCE).getChildren((Object)element);
                        }
                    });
                    this.busy = false;
                    return (Object[])oa[0];
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)o;
                    if (!element.isPopulated()) {
                        return true;
                    }
                    return this.getChildren(element).length > 0;
                }
                return false;
            }
        };
    }

    protected List getSelectedResources() {
        return super.getSelectedResources();
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        return (File)this.sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toString();
    }

    protected String getDescriptionLocation() {
        return this.descFilePathField.getText().trim();
    }

    protected boolean isSaveSettings() {
        if (this.saveSettingsButton != null) {
            return this.saveSettingsButton.getSelection();
        }
        return false;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        } else if (event.widget == this.descFileBrowseButton) {
            this.handleDescriptionFileBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(this.getShell());
        action.setShowNewConnectionPrompt(true);
        action.setShowPropertySheet(true, false);
        action.setFoldersOnly(true);
        action.run();
        IRemoteFile folder = action.getSelectedFolder();
        if (folder != null) {
            this.clearErrorMessage();
            this.setSourceName(Utilities.getAsString(folder));
            this.selectionGroup.setFocus();
        }
    }

    protected void handleDescriptionFileBrowseButtonPressed() {
        SaveAsDialog dialog = new SaveAsDialog(this.getContainer().getShell());
        dialog.create();
        dialog.getShell().setText(RemoteImportExportResources.IMPORT_EXPORT_DESCRIPTION_FILE_DIALOG_TITLE);
        dialog.setMessage(RemoteImportExportResources.IMPORT_EXPORT_DESCRIPTION_FILE_DIALOG_MESSAGE);
        dialog.setOriginalFile(this.createFileHandle((IPath)new Path(this.getDescriptionLocation())));
        if (dialog.open() == 0) {
            IPath path = dialog.getResult();
            path = path.removeFileExtension().addFileExtension("rimpfd");
            this.descFilePathField.setText(path.toString());
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath.isValidPath(filePath.toString()) && filePath.segmentCount() >= 2) {
            return SystemBasePlugin.getWorkspace().getRoot().getFile(filePath);
        }
        return null;
    }

    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected boolean isImportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator z = this.selectedTypes.iterator();
        while (z.hasNext()) {
            if (!extension.equalsIgnoreCase((String)z.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean isIncludedInImportData(MinimizedFileSystemElement element) {
        UniFilePlus file = (UniFilePlus)element.getFileSystemObject();
        RemoteImportWizard parentWizard = (RemoteImportWizard)this.getWizard();
        RemoteFileImportData importData = parentWizard.getImportData();
        return importData.doesExist(file);
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
    }

    protected void restoreWidgetValues() {
        IRemoteFile file;
        Object theSel;
        IStructuredSelection sel;
        Object initSelection;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            RemoteImportWizard parentWizard;
            boolean isInitializingFromImportData;
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames != null) {
                int i = 0;
                while (i < sourceNames.length) {
                    this.sourceNameField.add(sourceNames[i]);
                    ++i;
                }
            }
            if (!(isInitializingFromImportData = (parentWizard = (RemoteImportWizard)this.getWizard()).getInitializeFromImportData())) {
                this.reviewSynchronizeCheckbox.setSelection(settings.getBoolean(STORE_REVIEW_SYNCHRONIZE_ID));
                this.overwriteExistingResourcesCheckbox.setSelection(settings.getBoolean(STORE_OVERWRITE_EXISTING_RESOURCES_ID));
                boolean createStructure = settings.getBoolean(STORE_CREATE_CONTAINER_STRUCTURE_ID);
                this.createContainerStructureButton.setSelection(createStructure);
                this.createOnlySelectedButton.setSelection(!createStructure);
                boolean saveSettings = settings.getBoolean(STORE_CREATE_DESCRIPTION_FILE_ID);
                this.saveSettingsButton.setSelection(saveSettings);
                String descFilePathStr = settings.get(STORE_DESCRIPTION_FILE_NAME_ID);
                if (descFilePathStr == null) {
                    descFilePathStr = "";
                }
                this.descFilePathField.setText(descFilePathStr);
            } else {
                RemoteFileImportData importData = parentWizard.getImportData();
                String containerPath = importData.getContainerPath().toString();
                if (containerPath != null) {
                    this.setContainerFieldValue(containerPath);
                }
                this.reviewSynchronizeCheckbox.setSelection(importData.isReviewSynchronize());
                this.overwriteExistingResourcesCheckbox.setSelection(importData.isOverWriteExistingFiles());
                this.createContainerStructureButton.setSelection(importData.isCreateDirectoryStructure());
                this.createOnlySelectedButton.setSelection(importData.isCreateSelectionOnly());
                this.saveSettingsButton.setSelection(importData.isSaveSettings());
                String descFilePathStr = importData.getDescriptionFilePath();
                if (descFilePathStr == null) {
                    descFilePathStr = "";
                }
                this.descFilePathField.setText(descFilePathStr);
                UniFilePlus source = (UniFilePlus)importData.getSource();
                if (source != null) {
                    this.setSourceName(source.getCanonicalPath());
                }
            }
        }
        if ((initSelection = this.getInputObject()) != null && initSelection instanceof IStructuredSelection && (sel = (IStructuredSelection)initSelection).size() == 1 && (theSel = sel.getFirstElement()) instanceof IRemoteFile && (file = (IRemoteFile)theSel).isDirectory()) {
            this.setSourceName(Utilities.getAsString(file));
            this.initSourceNameSet = true;
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
            settings.put(STORE_REVIEW_SYNCHRONIZE_ID, this.reviewSynchronizeCheckbox.getSelection());
            settings.put(STORE_OVERWRITE_EXISTING_RESOURCES_ID, this.overwriteExistingResourcesCheckbox.getSelection());
            settings.put(STORE_CREATE_CONTAINER_STRUCTURE_ID, this.createContainerStructureButton.getSelection());
            settings.put(STORE_CREATE_DESCRIPTION_FILE_ID, this.isSaveSettings());
            settings.put(STORE_DESCRIPTION_FILE_NAME_ID, this.getDescriptionLocation());
        }
    }

    protected MinimizedFileSystemElement selectFiles(final Object rootFileSystemObject, final IImportStructureProvider structureProvider) {
        final MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                results[0] = RemoteImportWizardPage1.this.createRootElement(rootFileSystemObject, structureProvider);
            }
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            this.sourceDirectory = null;
            this.sourceNameField.setText("");
            this.resetSelection();
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length && selectionIndex < 0) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            if (Utilities.isConnectionValid(path, this.getShell())) {
                try {
                    this.sourceDirectory = null;
                    IHost as400Conn = Utilities.parseForSystemConnection(path);
                    if (as400Conn != null) {
                        IRemoteFile rf = Utilities.parseForIRemoteFile(path);
                        if (rf != null && rf.exists()) {
                            this.sourceDirectory = new UniFilePlus(rf);
                        }
                        this.sourceNameField.select(selectionIndex);
                    }
                    this.resetSelection();
                }
                catch (Exception e) {
                    Utilities.error(e);
                }
            }
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)fileElement;
                if (RemoteImportWizardPage1.this.isImportableExtension(file.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                String msg = RemoteImportExportResources.FILEMSG_IMPORT_FILTERING;
                monitor.beginTask(msg, -1);
                RemoteImportWizardPage1.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(false, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        this.updateSelections(selectionMap);
    }

    protected void setupSelectionsBasedOnImportData() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        final IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                int i = 0;
                while (i < files.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                    ++i;
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)fileElement;
                if (RemoteImportWizardPage1.this.isIncludedInImportData(file)) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                String msg = RemoteImportExportResources.FILEMSG_IMPORT_FILTERING;
                monitor.beginTask(msg, -1);
                RemoteImportWizardPage1.this.getSelectedResources(filter, monitor);
            }
        };
        try {
            dialog.run(false, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.getShell().update();
        this.updateSelections(selectionMap);
    }

    public void setVisible(boolean visible) {
        RemoteImportWizard parentWizard;
        boolean isInitializingFromImportData;
        super.setVisible(visible);
        this.resetSelection();
        if (this.initSourceNameSet) {
            this.setAllSelections(true);
            this.selectionGroup.setFocus();
        }
        if (isInitializingFromImportData = (parentWizard = (RemoteImportWizard)this.getWizard()).getInitializeFromImportData()) {
            this.setAllSelections(true);
            this.setupSelectionsBasedOnImportData();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected void updateWidgetEnablements() {
        if (this.saveSettingsButton != null && this.descFilePathLabel != null && this.descFilePathField != null && this.descFileBrowseButton != null) {
            boolean isSaveSettings = this.isSaveSettings();
            this.descFilePathLabel.setEnabled(isSaveSettings);
            this.descFilePathField.setEnabled(isSaveSettings);
            this.descFileBrowseButton.setEnabled(isSaveSettings);
        }
        if (this.reviewSynchronizeCheckbox != null) {
            boolean isReview = this.reviewSynchronizeCheckbox.getSelection();
            this.overwriteExistingResourcesCheckbox.setEnabled(!isReview);
            this.createContainerStructureButton.setEnabled(!isReview);
            this.createOnlySelectedButton.setEnabled(!isReview);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        this.enableButtonGroup(true);
        return true;
    }

    protected boolean validateOptionsGroup() {
        if (this.isSaveSettings()) {
            Path location = new Path(this.getDescriptionLocation());
            if (location.toString().length() == 0) {
                this.setErrorMessage((String)null);
                return false;
            }
            if (!location.toString().startsWith("/")) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_ABSOLUTE);
                return false;
            }
            IResource resource = this.findResource((IPath)location);
            if (resource != null && resource.getType() != 1) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_EXISTING_CONTAINER);
                return false;
            }
            resource = this.findResource(location.removeLastSegments(1));
            if (resource == null || resource.getType() == 1) {
                this.setErrorMessage(RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_NO_CONTAINER);
                return false;
            }
            String fileExtension = location.getFileExtension();
            if (fileExtension == null || !fileExtension.equals("rimpfd")) {
                this.setErrorMessage(NLS.bind((String)RemoteImportExportResources.IMPORT_EXPORT_ERROR_DESCRIPTION_INVALID_EXTENSION, (Object)"rimpfd"));
                return false;
            }
        }
        return true;
    }

    protected IResource findResource(IPath path) {
        IWorkspace workspace = SystemBasePlugin.getWorkspace();
        IStatus result = workspace.validatePath(path.toString(), 15);
        if (result.isOK()) {
            IWorkspaceRoot root = workspace.getRoot();
            if (root.exists(path)) {
                return root.findMember(path);
            }
            IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(path);
            if (variant != null) {
                return variant;
            }
        }
        return null;
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        IContainer container = this.getSpecifiedContainer();
        if (container == null) {
            return false;
        }
        if (container.getLocation() == null) {
            return false;
        }
        return container.getLocation().isPrefixOf(sourcePath);
    }

    public void setInputObject(Object inputObject) {
        this.inputObject = inputObject;
    }

    public Object getInputObject() {
        return this.inputObject;
    }

    public boolean performFinish() {
        return this.finish();
    }

    public void cancel() {
        if (this._queryAllJob != null && this._queryAllJob.isActive()) {
            this._queryAllJob.cancel();
        }
    }

    public void setHelp(String id) {
        if (this.parentComposite != null) {
            SystemWidgetHelpers.setHelp((Control)this.parentComposite, (String)this.helpId);
        }
        this.helpId = id;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
    }

    public void clearMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearMessage();
        }
    }

    public SystemMessage getSystemErrorMessage() {
        if (this.msgLine != null) {
            return this.msgLine.getSystemErrorMessage();
        }
        return null;
    }

    public void setErrorMessage(SystemMessage message) {
        if (this.msgLine != null) {
            if (message != null) {
                this.msgLine.setErrorMessage(message);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            this.pendingErrorMessage = message;
        }
    }

    public void setErrorMessage(Throwable exc) {
        if (this.msgLine != null) {
            this.msgLine.setErrorMessage(exc);
        } else {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED, exc);
            this.pendingErrorMessage = msg;
        }
    }

    public void setErrorMessage(String message) {
        if (this.msgLine != null) {
            if (message != null) {
                this.msgLine.setErrorMessage(message);
            } else {
                this.msgLine.clearErrorMessage();
            }
        } else {
            this.pendingErrorString = message;
        }
    }

    public void setMessage(SystemMessage message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        } else {
            this.pendingMessage = message;
        }
    }

    public void setMessage(String message) {
        if (this.msgLine != null) {
            this.msgLine.setMessage(message);
        } else {
            this.pendingString = message;
        }
    }

    public boolean determinePageCompletion() {
        if (this._queryAllJob != null && this._queryAllJob.isActive()) {
            return false;
        }
        return super.determinePageCompletion();
    }

    private class DummyProvider
    implements ISelectionProvider {
        private DummyProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return null;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private class QueryAllJob
    extends Job {
        private Object _fileSystemObject;
        private IImportStructureProvider _provider;
        private MinimizedFileSystemElement _element;
        private volatile boolean _isActive;

        public QueryAllJob(Object fileSystemObject, IImportStructureProvider provider, MinimizedFileSystemElement element) {
            super("Querying All");
            this._isActive = false;
            this._fileSystemObject = fileSystemObject;
            this._provider = provider;
            this._element = element;
        }

        public IStatus run(IProgressMonitor monitor) {
            this._isActive = true;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    RemoteImportWizardPage1.this.updateWidgetEnablements();
                    RemoteImportWizardPage1.this.selectionGroup.setAllSelections(true);
                }
            });
            this.query(this._fileSystemObject, this._element, monitor);
            this._isActive = false;
            return Status.OK_STATUS;
        }

        public boolean isActive() {
            return this._isActive;
        }

        private void query(Object parent, MinimizedFileSystemElement element, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            ArrayList children = this._provider.getChildren(parent);
            if (children == null) {
                children = new ArrayList(1);
            }
            Iterator childrenEnum = children.iterator();
            ArrayList<MinimizedFileSystemElement> resultsToQuery = new ArrayList<MinimizedFileSystemElement>();
            while (childrenEnum.hasNext()) {
                Object child = childrenEnum.next();
                String elementLabel = this._provider.getLabel(child);
                MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, element, this._provider.isFolder(child));
                result.setFileSystemObject(child);
                if (!(child instanceof UniFilePlus) || !((UniFilePlus)child).isDirectory()) continue;
                resultsToQuery.add(result);
            }
            if (element == this._element) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        DummyProvider provider = new DummyProvider();
                        StructuredSelection sel1 = new StructuredSelection((Object)QueryAllJob.this._element.getParent());
                        SelectionChangedEvent evt1 = new SelectionChangedEvent((ISelectionProvider)provider, (ISelection)sel1);
                        RemoteImportWizardPage1.this.selectionGroup.selectionChanged(evt1);
                        StructuredSelection sel2 = new StructuredSelection((Object)QueryAllJob.this._element);
                        SelectionChangedEvent evt2 = new SelectionChangedEvent((ISelectionProvider)provider, (ISelection)sel2);
                        RemoteImportWizardPage1.this.selectionGroup.selectionChanged(evt2);
                    }
                });
            }
            int i = 0;
            while (i < resultsToQuery.size()) {
                MinimizedFileSystemElement celement = (MinimizedFileSystemElement)resultsToQuery.get(i);
                this.query(celement.getFileSystemObject(), celement, monitor);
                celement.setPopulated(true);
                ++i;
            }
            element.setPopulated(true);
        }
    }
}

