/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.local;

import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorService;
import org.eclipse.rse.internal.connectorservice.local.LocalConnectorServiceManager;
import org.eclipse.rse.internal.services.local.ILocalService;
import org.eclipse.rse.internal.services.local.files.LocalFileService;
import org.eclipse.rse.internal.services.local.search.LocalSearchService;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.internal.subsystems.files.local.LocalLanguageUtilityFactory;
import org.eclipse.rse.internal.subsystems.files.local.LocalSearchResultConfiguration;
import org.eclipse.rse.internal.subsystems.files.local.model.LocalFileAdapter;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.ui.SystemBasePlugin;

public class LocalFileSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    protected boolean _isWindows;
    protected IHostFileToRemoteFileAdapter _hostFileAdapter;

    public LocalFileSubSystemConfiguration() {
        String osName = System.getProperty("os.name").toLowerCase();
        this._isWindows = osName.startsWith("windows");
        this.setIsUnixStyle(!this._isWindows);
    }

    public boolean isFactoryFor(Class subSystemType) {
        boolean isFor = FileServiceSubSystem.class.equals((Object)subSystemType);
        return isFor;
    }

    public boolean supportsArchiveManagement() {
        return true;
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool;
        block7: {
            pool = null;
            pool = mgr.createSystemFilterPool(LocalFileSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId()), true);
            if (pool != null) break block7;
            SystemBasePlugin.logError((String)("Creating default filter pool " + LocalFileSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId()) + " for mgr " + mgr.getName() + " failed."), null);
            return null;
        }
        try {
            if (this.isUserPrivateProfile(mgr)) {
                String myHomeFilterName = SystemFileResources.RESID_FILTER_MYHOME;
                RemoteFileFilterString myDocsFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
                myDocsFilterString.setPath(String.valueOf(System.getProperty("user.home")) + this.getSeparator());
                String[] myDocsFilterStrings = new String[]{myDocsFilterString.toString()};
                mgr.createSystemFilter((ISystemFilterContainer)pool, myHomeFilterName, myDocsFilterStrings);
                RemoteFileFilterString defaultFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
                if (!this._isWindows) {
                    defaultFilterString.setPath(this.getSeparator());
                }
                String[] filterStrings = new String[]{defaultFilterString.toString()};
                String filterName = null;
                filterName = this._isWindows ? SystemFileResources.RESID_FILTER_DRIVES : SystemFileResources.RESID_FILTER_ROOTFILES;
                mgr.createSystemFilter((ISystemFilterContainer)pool, filterName, filterStrings);
            } else {
                RemoteFileFilterString defaultFilterString = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this);
                if (!this._isWindows) {
                    defaultFilterString.setPath(this.getSeparator());
                }
                String[] filterStrings = new String[]{defaultFilterString.toString()};
                String filterName = null;
                filterName = this._isWindows ? SystemFileResources.RESID_FILTER_DRIVES : SystemFileResources.RESID_FILTER_ROOTFILES;
                mgr.createSystemFilter((ISystemFilterContainer)pool, filterName, filterStrings);
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error creating default filter pool", (Throwable)exc);
        }
        return pool;
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        LocalConnectorService connectorService = (LocalConnectorService)this.getConnectorService(host);
        FileServiceSubSystem subsys = new FileServiceSubSystem(host, (IConnectorService)connectorService, this.getFileService(host), this.getHostFileAdapter(), this.getSearchService(host));
        return subsys;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return true;
    }

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public boolean supportsSubSystemConnect() {
        return false;
    }

    public boolean supportsDeferredQueries() {
        return false;
    }

    public IConnectorService getConnectorService(IHost host) {
        return LocalConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        LocalConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public IFileService createFileService(IHost host) {
        return new LocalFileService((ISystemFileTypes)RemoteFileUtility.getSystemFileTransferModeRegistry());
    }

    public ISearchService createSearchService(IHost host) {
        return new LocalSearchService();
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost host, IHostSearchResultSet resultSet, Object searchTarget, SystemSearchString searchString) {
        LocalSearchResultConfiguration config = new LocalSearchResultConfiguration(resultSet, searchTarget, searchString, this.getSearchService(host));
        resultSet.addSearchConfiguration((IHostSearchResultConfiguration)config);
        return config;
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        if (this._hostFileAdapter == null) {
            this._hostFileAdapter = new LocalFileAdapter();
        }
        return this._hostFileAdapter;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem ss) {
        return LocalLanguageUtilityFactory.getInstance(ss);
    }

    public Class getServiceImplType() {
        return ILocalService.class;
    }

    public String getEditorProfileID() {
        return "universallocal";
    }
}

