/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets;

import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class SystemEditPaneStateMachine {
    private Composite composite;
    private Button applyButton;
    private Button resetButton;
    private int mode;
    private int state;
    private int backupMode;
    private int backupState;
    private SystemMessage pendingMsg;
    private String applyLabel_applyMode;
    private String applyLabel_newMode;
    private String applyTip_applyMode;
    private String applyTip_newMode;
    private boolean applyLabelMode;
    private boolean newSetByDelete;

    public SystemEditPaneStateMachine(Composite composite, Button applyButton, Button resetButton) {
        this.composite = composite;
        this.applyButton = applyButton;
        this.resetButton = resetButton;
        this.applyLabel_applyMode = applyButton.getText();
        this.applyTip_applyMode = applyButton.getToolTipText();
        this.applyLabelMode = true;
        this.setApplyLabelForNewMode(SystemResources.BUTTON_CREATE_LABEL, SystemResources.BUTTON_CREATE_TOOLTIP);
        this.setUnsetMode();
    }

    public void setApplyLabelForNewMode(String label, String tooltip) {
        this.applyLabel_newMode = label;
        this.applyTip_newMode = tooltip;
    }

    public void setNewMode() {
        this.setButtonText(this.mode, 4);
        this.setMode(4);
        this.setState(128);
        this.enableButtons();
        if (!this.composite.isVisible()) {
            this.composite.setVisible(true);
        }
    }

    public void setEditMode() {
        this.setButtonText(this.mode, 8);
        this.setMode(8);
        this.setState(128);
        this.enableButtons();
        if (!this.composite.isVisible()) {
            this.composite.setVisible(true);
        }
    }

    public void setUnsetMode() {
        this.setButtonText(this.mode, 2);
        this.setMode(2);
        this.setState(128);
        this.enableButtons();
        if (this.composite.isVisible()) {
            this.composite.setVisible(false);
        }
    }

    public void setChangesMade() {
        this.setState(256);
        this.enableButtons();
    }

    public boolean isSaveRequired() {
        boolean changesPending = this.areChangesPending();
        if (changesPending) {
            if (this.pendingMsg == null) {
                this.pendingMsg = RSEUIPlugin.getPluginMessage("RSEG1201");
            }
            SystemMessageDialog pendingMsgDlg = new SystemMessageDialog(this.composite.getShell(), this.pendingMsg);
            try {
                changesPending = pendingMsgDlg.openQuestion();
            }
            catch (Exception exception) {}
        }
        this.setState(128);
        return changesPending;
    }

    public void applyPressed() {
        this.setState(512);
        this.enableButtons();
    }

    public void resetPressed() {
        this.setState(128);
        this.enableButtons();
    }

    public boolean areChangesPending() {
        return this.state == 256;
    }

    public Button getResetButton() {
        return this.resetButton;
    }

    public Button getApplyButton() {
        return this.applyButton;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public int getMode() {
        return this.mode;
    }

    public int getState() {
        return this.state;
    }

    private void enableButtons() {
        boolean enableApply = false;
        boolean enableReset = false;
        switch (this.state) {
            case 128: {
                enableApply = false;
                enableReset = false;
                break;
            }
            case 512: {
                enableApply = false;
                enableReset = false;
                break;
            }
            case 256: {
                enableApply = true;
                enableReset = true;
            }
        }
        this.applyButton.setEnabled(enableApply);
        if (this.resetButton != null) {
            this.resetButton.setEnabled(enableReset);
        }
    }

    private void setButtonText(int oldMode, int newMode) {
        if (oldMode != newMode) {
            if (newMode == 4 && this.applyLabelMode) {
                this.applyButton.setText(this.applyLabel_newMode);
                this.applyButton.setToolTipText(this.applyTip_newMode);
                this.applyLabelMode = false;
            } else if (newMode == 8 && !this.applyLabelMode) {
                this.applyButton.setText(this.applyLabel_applyMode);
                this.applyButton.setToolTipText(this.applyTip_applyMode);
                this.applyLabelMode = true;
            }
            Composite parent = this.applyButton.getParent();
            parent.layout();
            parent.update();
        }
    }

    private void setMode(int mode) {
        this.mode = mode;
    }

    private void setState(int state) {
        this.state = state;
    }

    public void setNewSetByDelete(boolean newSetByDelete) {
        this.newSetByDelete = newSetByDelete;
    }

    public boolean getNewSetByDelete() {
        return this.newSetByDelete;
    }

    public void backup() {
        this.backupMode = this.mode;
        this.backupState = this.state;
    }

    public void restore() {
        switch (this.backupMode) {
            case 2: {
                this.setUnsetMode();
                break;
            }
            case 4: {
                this.setNewMode();
                break;
            }
            case 8: {
                this.setEditMode();
            }
        }
        switch (this.backupState) {
            case 256: {
                this.setChangesMade();
                break;
            }
            case 128: {
                break;
            }
            case 512: {
                this.applyPressed();
            }
        }
    }
}

