/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.processes.shell.linux;

import java.util.StringTokenizer;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.LinuxProcessHelper;
import org.eclipse.rse.services.processes.AbstractHostProcess;

public class LinuxHostProcess
extends AbstractHostProcess {
    private static String NAME = "Name";
    private static String STATE = "State";
    private static String TGID = "Tgid";
    private static String PID = "Pid";
    private static String PPID = "PPid";
    private static String TRACERPID = "TracerPid";
    private static String UID = "Uid";
    private static String GID = "Gid";
    private static String VMSIZE = "VmSize";
    private static String VMRSS = "VmRSS";
    private static String STATUS_DELIMITER = "|";
    private LinuxProcessHelper linuxProcessHelper;

    public LinuxHostProcess(LinuxProcessHelper linuxProcessHelper) {
        this.linuxProcessHelper = linuxProcessHelper;
    }

    public void processLine(String line) {
        String firstValue;
        String[] result = line.split(":");
        if (result.length < 2) {
            return;
        }
        String propertyName = result[0];
        String propertyValue = result[1].trim();
        if (NAME.equals(propertyName)) {
            this.setName(propertyValue);
            this.setLabel(propertyValue);
            this.setVmSizeInKB("0");
            this.setVmRSSInKB("0");
        } else if (STATE.equals(propertyName)) {
            String firstValue2 = this.getFirstValue(propertyValue);
            if (firstValue2 != null) {
                this.setState(this.linuxProcessHelper.convertToStateCode(propertyValue));
            }
        } else if (TGID.equals(propertyName)) {
            this.setTgid(propertyValue);
        } else if (PID.equals(propertyName)) {
            this.setPid(propertyValue);
        } else if (PPID.equals(propertyName)) {
            this.setPPid(propertyValue);
        } else if (TRACERPID.equals(propertyName)) {
            this.setTracerPid(propertyValue);
        } else if (TRACERPID.equals(propertyName)) {
            this.setTracerPid(propertyValue);
        } else if (UID.equals(propertyName)) {
            String firstValue3 = this.getFirstValue(propertyValue);
            if (firstValue3 != null) {
                this.setUid(firstValue3);
                this.setUsername(this.linuxProcessHelper.getUsername(firstValue3));
            }
        } else if (GID.equals(propertyName)) {
            String firstValue4 = this.getFirstValue(propertyValue);
            if (firstValue4 != null) {
                this.setGid(firstValue4);
            }
        } else if (VMSIZE.equals(propertyName)) {
            String firstValue5 = this.getFirstValue(propertyValue);
            if (firstValue5 != null) {
                this.setVmSizeInKB(firstValue5);
            }
        } else if (VMRSS.equals(propertyName) && (firstValue = this.getFirstValue(propertyValue)) != null) {
            this.setVmRSSInKB(firstValue);
        }
    }

    public static boolean isNewRecord(String line) {
        String[] result = line.split(":");
        return result.length >= 2 && NAME.equals(result[0]);
    }

    private String getFirstValue(String propertyValue) {
        StringTokenizer st = new StringTokenizer(propertyValue);
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return null;
    }

    public String getStatusLine() {
        StringBuffer statusLine = new StringBuffer();
        statusLine = statusLine.append(this.getPid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getName()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getState()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getTgid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getPPid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getTracerPid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getUid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getUsername()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getGid()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getVmSizeInKB()).append(STATUS_DELIMITER);
        statusLine = statusLine.append(this.getVmRSSInKB()).append(STATUS_DELIMITER);
        return statusLine.toString();
    }
}

