/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.views;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.terminals.ui.TerminalUIResources;
import org.eclipse.rse.internal.terminals.ui.views.TerminalViewTab;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.terminals.core.elements.TerminalElement;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class TerminalViewer
extends ViewPart
implements ISelectionListener,
SelectionListener,
ISelectionChangedListener,
ISystemResourceChangeListener,
ISystemShellProvider,
IRSEViewPart,
IMenuListener,
ISystemMessageLine {
    private TerminalViewTab tabFolder;
    private PageBook pagebook;
    private Label noTabShownLabel;
    public static String VIEW_ID = "org.eclipse.rse.terminals.ui.view.TerminalView";

    public void createPartControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
        this.tabFolder = new TerminalViewTab((Composite)this.pagebook, this);
        this.tabFolder.getFolder().addSelectionListener((SelectionListener)this);
        this.noTabShownLabel = new Label((Composite)this.pagebook, 16576);
        this.noTabShownLabel.setText(TerminalUIResources.TerminalViewer_text);
        this.showEmptyPage();
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        this.fillLocalToolBar();
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        if (event.getType() == 141) {
            Object source = event.getSource();
            if (source instanceof TerminalElement) {
                this.tabFolder.disposePageFor(((TerminalElement)source).getName());
            }
        } else if (event.getType() == 82) {
            if (this.tabFolder.getItemCount() == 0) {
                this.showEmptyPage();
            } else {
                this.showTabsPage();
            }
        }
    }

    public Shell getShell() {
        return null;
    }

    public Viewer getRSEViewer() {
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    public void clearErrorMessage() {
    }

    public void clearMessage() {
    }

    public String getErrorMessage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public SystemMessage getSystemErrorMessage() {
        return null;
    }

    public void setErrorMessage(String message) {
    }

    public void setErrorMessage(SystemMessage message) {
    }

    public void setErrorMessage(Throwable exc) {
    }

    public void setMessage(String message) {
    }

    public void setMessage(SystemMessage message) {
    }

    public void fillLocalToolBar() {
    }

    public TerminalViewTab getTabFolder() {
        return this.tabFolder;
    }

    private void showEmptyPage() {
        this.pagebook.showPage((Control)this.noTabShownLabel);
    }

    private void showTabsPage() {
        this.pagebook.showPage((Control)this.tabFolder);
    }
}

