#!/bin/sh
#
# Script to re-publish bundles and features from a (stripped-down) repoisitory in p2 format.
# Requires Eclipse SDK to be extracted (see ECLIPSE variable below).
#
# Usage: cd repo; rm features/unwanted; ../republish.sh
#
if [ ! -f artifacts.jar -a ! -f artifacts.xml ]; then
  echo "ERROR: Must execute in existing p2 repo to republish content.jar and artifacts.jar"
  exit 1
fi
ECLIPSE=../../../../eclipse/eclipse
#SRC=`pwd`
SRC=.
TGT=`pwd`
if [ ! -f $ECLIPSE ]; then 
  echo "ERROR: Eclipse not found"
  exit 1
fi
rm content.* artifacts.*
$ECLIPSE \
      -noSplash \
      -application org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher \
      -metadataRepository file:$TGT \
      -artifactRepository file:$TGT \
      -bundles $SRC/plugins \
      -features $SRC/features \
      -compress
# -publishArtifacts

if [ -f category.xml ]; then
  $ECLIPSE \
      -noSplash \
      -application org.eclipse.equinox.p2.publisher.CategoryPublisher \
      -metadataRepository file:$TGT \
      -categoryDefinition file:`pwd`/category.xml \
      -compress
fi

