/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui;

import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.snippets.SnippetManager;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.model.ITMModelManager;
import org.eclipse.tm4e.ui.snippets.ISnippetManager;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TMUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tm4e.ui";
    private static final String TRACE_ID = "org.eclipse.tm4e.ui/trace";
    private static volatile @Nullable TMUIPlugin plugin;

    public static @Nullable String getPreference(String key, @Nullable String defaultValue) {
        return Platform.getPreferencesService().getString(PLUGIN_ID, key, defaultValue, null);
    }

    public static void log(IStatus status) {
        TMUIPlugin p = plugin;
        if (p != null) {
            p.getLog().log(status);
        } else {
            System.out.println(status);
        }
    }

    public static void logError(Exception ex) {
        TMUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex));
    }

    public static void logTrace(Exception ex) {
        if (TMUIPlugin.isLogTraceEnabled()) {
            TMUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
    }

    public static void logTrace(String message) {
        if (TMUIPlugin.isLogTraceEnabled()) {
            TMUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, message));
        }
    }

    public static boolean isLogTraceEnabled() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)TRACE_ID));
    }

    public void start(@Nullable BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (TMUIPlugin.isLogTraceEnabled()) {
            String tm4eCorePluginId = "org.eclipse.tm4e.core";
            Logger tm4eCoreLogger = Logger.getLogger("org.eclipse.tm4e.core");
            tm4eCoreLogger.setLevel(Level.FINEST);
            tm4eCoreLogger.addHandler(new Handler(){

                @Override
                public void publish(@Nullable LogRecord entry) {
                    if (entry != null) {
                        TMUIPlugin.log((IStatus)new Status(this.toSeverity(entry.getLevel()), "org.eclipse.tm4e.core", entry.getParameters() == null || entry.getParameters().length == 0 ? entry.getMessage() : MessageFormat.format(entry.getMessage(), entry.getParameters())));
                    }
                }

                private int toSeverity(Level level) {
                    if (level.intValue() >= Level.SEVERE.intValue()) {
                        return 4;
                    }
                    if (level.intValue() >= Level.WARNING.intValue()) {
                        return 2;
                    }
                    return 1;
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
        }
    }

    public void stop(@Nullable BundleContext context) throws Exception {
        ColorManager.getInstance().dispose();
        plugin = null;
        super.stop(context);
    }

    public static @Nullable TMUIPlugin getDefault() {
        return plugin;
    }

    public static ITMModelManager getTMModelManager() {
        return TMModelManager.INSTANCE;
    }

    public static IThemeManager getThemeManager() {
        return ThemeManager.getInstance();
    }

    public static ISnippetManager getSnippetManager() {
        return SnippetManager.getInstance();
    }
}

