/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tm4e.registry.ITMResource;

public class TMResource
implements ITMResource {
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    private String path;
    private String pluginId;

    public TMResource() {
    }

    public TMResource(String path) {
        this.path = path;
    }

    public TMResource(IConfigurationElement ce) {
        this(ce.getAttribute("path"));
        this.pluginId = ce.getNamespaceIdentifier();
    }

    public TMResource(String path, String pluginId) {
        this.path = path;
        this.pluginId = pluginId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.path == null || this.path.length() < 0) {
            return null;
        }
        if (this.pluginId != null) {
            URL url = new URL(PLATFORM_PLUGIN + this.pluginId + "/" + this.path);
            return url.openStream();
        }
        return new FileInputStream(new File(this.path));
    }

    protected String getResourceContent() {
        InputStream in;
        block3: {
            try {
                in = this.getInputStream();
                if (in != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return TMResource.convertStreamToString(in);
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner s = null;){
            s = new Scanner(is);
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }
}

