/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.grammar.ScopeMetadata;
import org.eclipse.tm4e.core.theme.IThemeProvider;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class ScopeMetadataProvider {
    private static final ScopeMetadata _NULL_SCOPE_METADATA = new ScopeMetadata("", 0, 0, null);
    private static final Pattern STANDARD_TOKEN_TYPE_REGEXP = Pattern.compile("\\b(comment|string|regex)\\b");
    private static final String COMMENT_TOKEN_TYPE = "comment";
    private static final String STRING_TOKEN_TYPE = "string";
    private static final String REGEX_TOKEN_TYPE = "regex";
    private final int initialLanguage;
    private final IThemeProvider themeProvider;
    private final Map<String, ScopeMetadata> cache;
    private ScopeMetadata defaultMetaData;
    private final Map<String, Integer> embeddedLanguages;
    private Pattern embeddedLanguagesRegex;

    public ScopeMetadataProvider(int initialLanguage, IThemeProvider themeProvider, Map<String, Integer> embeddedLanguages) {
        Set escapedScopes;
        this.initialLanguage = initialLanguage;
        this.themeProvider = themeProvider;
        this.cache = new HashMap<String, ScopeMetadata>();
        this.onDidChangeTheme();
        this.embeddedLanguages = new HashMap<String, Integer>();
        if (embeddedLanguages != null) {
            Set<Map.Entry<String, Integer>> languages = embeddedLanguages.entrySet();
            for (Map.Entry<String, Integer> language : languages) {
                String scope = language.getKey();
                int languageId = language.getValue();
                this.embeddedLanguages.put(scope, languageId);
            }
        }
        this.embeddedLanguagesRegex = (escapedScopes = this.embeddedLanguages.keySet().stream().map(ScopeMetadataProvider::escapeRegExpCharacters).collect(Collectors.toSet())).isEmpty() ? null : null;
    }

    public void onDidChangeTheme() {
        this.cache.clear();
        this.defaultMetaData = new ScopeMetadata("", this.initialLanguage, 0, Arrays.asList(this.themeProvider.getDefaults()));
    }

    public ScopeMetadata getDefaultMetadata() {
        return this.defaultMetaData;
    }

    private static String escapeRegExpCharacters(String value) {
        return value;
    }

    public ScopeMetadata getMetadataForScope(String scopeName) {
        if (scopeName == null) {
            return _NULL_SCOPE_METADATA;
        }
        ScopeMetadata value = this.cache.get(scopeName);
        if (value != null) {
            return value;
        }
        value = this.doGetMetadataForScope(scopeName);
        this.cache.put(scopeName, value);
        return value;
    }

    private ScopeMetadata doGetMetadataForScope(String scopeName) {
        int languageId = this.scopeToLanguage(scopeName);
        int standardTokenType = ScopeMetadataProvider.toStandardTokenType(scopeName);
        List<ThemeTrieElementRule> themeData = this.themeProvider.themeMatch(scopeName);
        return new ScopeMetadata(scopeName, languageId, standardTokenType, themeData);
    }

    private int scopeToLanguage(String scope) {
        if (scope == null) {
            return 0;
        }
        if (this.embeddedLanguagesRegex == null) {
            return 0;
        }
        return 0;
    }

    private static int toStandardTokenType(String tokenType) {
        Matcher m = STANDARD_TOKEN_TYPE_REGEXP.matcher(tokenType);
        if (!m.find()) {
            return 0;
        }
        String group = m.group();
        if (COMMENT_TOKEN_TYPE.equals(group)) {
            return 1;
        }
        if (STRING_TOKEN_TYPE.equals(group)) {
            return 2;
        }
        if (REGEX_TOKEN_TYPE.equals(group)) {
            return 4;
        }
        throw new TMException("Unexpected match for standard token type!");
    }
}

