/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.registry.IGrammarDefinition;

final class GrammarCache {
    private final Map<String, IGrammarDefinition> definitions = new HashMap<String, IGrammarDefinition>();
    private final Map<String, Collection<String>> injections = new HashMap<String, Collection<String>>();
    private final Map<IContentType, String> scopeNameBindings = new HashMap<IContentType, String>();

    GrammarCache() {
    }

    void registerGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.put(definition.getScopeName(), definition);
    }

    void unregisterGrammarDefinition(IGrammarDefinition definition) {
        this.definitions.remove(definition.getScopeName());
    }

    Collection<IGrammarDefinition> getDefinitions() {
        return this.definitions.values();
    }

    @Nullable IGrammarDefinition getDefinition(String scopeName) {
        return this.definitions.get(scopeName);
    }

    @Nullable Collection<String> getInjections(String scopeName) {
        return this.injections.get(scopeName);
    }

    void registerInjection(String scopeName, String injectTo) {
        Collection<String> injections = this.getInjections(injectTo);
        if (injections == null) {
            injections = new ArrayList<String>();
            this.injections.put(injectTo, injections);
        }
        injections.add(scopeName);
    }

    @Nullable String getScopeNameForContentType(IContentType contentType) {
        return this.scopeNameBindings.get(contentType);
    }

    List<IContentType> getContentTypesForScope(@Nullable String scopeName) {
        if (scopeName == null) {
            return Collections.emptyList();
        }
        return this.scopeNameBindings.entrySet().stream().filter(map -> scopeName.equals(map.getValue())).map(Map.Entry::getKey).toList();
    }

    void registerContentTypeBinding(IContentType contentType, String scopeName) {
        this.scopeNameBindings.put(contentType, scopeName);
    }
}

