/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public class ArrayExtensions {
    @Inline(value="$1[$2] = $3")
    public static <T, E extends T> T set(T[] array, int index, E value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2]")
    public static <T> T get(T[] array, int index) {
        return array[index];
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static <T> T[] clone(T[] array) {
        return (Object[])array.clone();
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(Object[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(Object[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(Object[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1[$2]")
    public static boolean get(boolean[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static boolean set(boolean[] array, int index, boolean value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(boolean[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(boolean[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(boolean[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static boolean[] clone(boolean[] array) {
        return (boolean[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static double get(double[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static double set(double[] array, int index, double value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(double[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(double[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(double[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static double[] clone(double[] array) {
        return (double[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static float get(float[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static float set(float[] array, int index, float value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(float[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(float[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(float[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static float[] clone(float[] array) {
        return (float[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static long get(long[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static long set(long[] array, int index, long value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(long[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(long[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(long[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static long[] clone(long[] array) {
        return (long[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static int get(int[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static int set(int[] array, int index, int value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(int[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(int[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(int[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static int[] clone(int[] array) {
        return (int[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static char get(char[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static char set(char[] array, int index, char value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(char[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(char[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(char[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static char[] clone(char[] array) {
        return (char[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static short get(short[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static short set(short[] array, int index, short value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(short[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(short[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(short[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static short[] clone(short[] array) {
        return (short[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2]")
    public static byte get(byte[] array, int index) {
        return array[index];
    }

    @Inline(value="$1[$2] = $3")
    public static byte set(byte[] array, int index, byte value) {
        array[index] = value;
        return value;
    }

    @Pure
    @Inline(value="$1.length")
    public static int length(byte[] array) {
        return array.length;
    }

    @Pure
    @Inline(value="$1.hashCode()")
    public static int hashCode(byte[] array) {
        return array.hashCode();
    }

    @Pure
    @Inline(value="$1.equals($2)")
    public static boolean equals(byte[] array, Object other) {
        return array.equals(other);
    }

    @Pure
    @Inline(value="$1.clone()")
    @GwtIncompatible(value="clone")
    public static byte[] clone(byte[] array) {
        return (byte[])array.clone();
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static <T> T get(T[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static <T, E extends T> T set(T[][] array, int index0, int index1, E value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static boolean get(boolean[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static boolean set(boolean[][] array, int index0, int index1, boolean value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static double get(double[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static double set(double[][] array, int index0, int index1, double value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static float get(float[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static float set(float[][] array, int index0, int index1, float value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static long get(long[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static long set(long[][] array, int index0, int index1, long value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2]")
    public static int get(int[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static int set(int[][] array, int index0, int index1, int value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static char get(char[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static char set(char[][] array, int index0, int index1, char value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static short get(short[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static short set(short[][] array, int index0, int index1, short value) {
        array[index0][index1] = value;
        return value;
    }

    @Pure
    @Inline(value="$1[$2][$3]")
    public static byte get(byte[][] array, int index0, int index1) {
        return array[index0][index1];
    }

    @Inline(value="$1[$2][$3] = $4")
    public static byte set(byte[][] array, int index0, int index1, byte value) {
        array[index0][index1] = value;
        return value;
    }
}

