/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class Es6ConvertSuper
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final DiagnosticType NO_SUPERTYPE = DiagnosticType.error("JSC_NO_SUPERTYPE", "The super keyword may only appear in classes with an extends clause.");
    private final AbstractCompiler compiler;

    public Es6ConvertSuper(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private void checkClassSuperReferences(Node classNode) {
        Node className = classNode.getFirstChild();
        Node superClassName = className.getNext();
        if (NodeUtil.referencesSuper(classNode) && superClassName.isEmpty()) {
            this.compiler.report(JSError.make(classNode, NO_SUPERTYPE, new String[0]));
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isClass()) {
            boolean hasConstructor = false;
            for (Node member = n.getLastChild().getFirstChild(); member != null; member = member.getNext()) {
                if (!member.isMemberFunctionDef() || !member.getString().equals("constructor")) continue;
                hasConstructor = true;
            }
            if (!hasConstructor) {
                this.addSyntheticConstructor(n);
            }
            this.checkClassSuperReferences(n);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isSuper()) {
            this.visitSuper(n, parent);
        }
    }

    private void addSyntheticConstructor(Node classNode) {
        Node memberDef;
        Node superClass = classNode.getSecondChild();
        Node classMembers = classNode.getLastChild();
        if (superClass.isEmpty()) {
            memberDef = IR.memberFunctionDef("constructor", IR.function(IR.name(""), IR.paramList(), IR.block()));
        } else {
            if (!superClass.isQualifiedName()) {
                return;
            }
            Node body = IR.block();
            if (!classNode.isFromExterns()) {
                Node exprResult = IR.exprResult(IR.call(IR.getprop(superClass.cloneTree(), IR.string("apply")), IR.thisNode(), IR.name("arguments")));
                body.addChildrenToFront(exprResult);
            }
            Node constructor = IR.function(IR.name(""), IR.paramList(IR.name("var_args")), body);
            memberDef = IR.memberFunctionDef("constructor", constructor);
        }
        memberDef.useSourceInfoIfMissingFromForTree(classNode);
        classMembers.addChildToFront(memberDef);
    }

    private void visitSuper(Node node, Node parent) {
        Node enclosingCall = parent;
        Node potentialCallee = node;
        if (!parent.isCall()) {
            enclosingCall = parent.getParent();
            potentialCallee = parent;
        }
        if (!enclosingCall.isCall() || enclosingCall.getFirstChild() != potentialCallee || enclosingCall.getFirstChild().isGetElem()) {
            this.compiler.report(JSError.make(node, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Only calls to super or to a method of super are supported."));
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        if (clazz == null) {
            this.compiler.report(JSError.make(node, NO_SUPERTYPE, new String[0]));
            return;
        }
        if (NodeUtil.getNameNode(clazz) == null) {
            return;
        }
        Node superName = clazz.getSecondChild();
        if (!superName.isQualifiedName()) {
            return;
        }
        Node enclosingMemberDef = NodeUtil.getEnclosingClassMemberFunction(node);
        if (enclosingMemberDef.isStaticMember()) {
            potentialCallee.detachFromParent();
            if (potentialCallee == node) {
                potentialCallee = IR.getprop(superName.cloneTree(), IR.string(enclosingMemberDef.getString()));
                enclosingCall.putBooleanProp(50, false);
            } else {
                potentialCallee.replaceChild(node, superName.cloneTree());
            }
            Node callTarget = IR.getprop(potentialCallee, IR.string("call"));
            enclosingCall.addChildToFront(callTarget);
            enclosingCall.addChildAfter(IR.thisNode(), callTarget);
            enclosingCall.useSourceInfoIfMissingFromForTree(enclosingCall);
            this.compiler.reportCodeChange();
            return;
        }
        Node callName = enclosingCall.removeFirstChild();
        String methodName = callName.isSuper() ? enclosingMemberDef.getString() : callName.getLastChild().getString();
        Node baseCall = this.baseCall(superName.getQualifiedName(), methodName, enclosingCall.removeChildren());
        baseCall.useSourceInfoIfMissingFromForTree(enclosingCall);
        enclosingCall.getParent().replaceChild(enclosingCall, baseCall);
        this.compiler.reportCodeChange();
    }

    private Node baseCall(String baseClass, String methodName, Node arguments) {
        Preconditions.checkNotNull((Object)baseClass);
        Preconditions.checkNotNull((Object)methodName);
        String baseMethodName = methodName.equals("constructor") ? baseClass + ".call" : Joiner.on((char)'.').join((Object)baseClass, (Object)"prototype", new Object[]{methodName, "call"});
        Node methodCall = NodeUtil.newQName(this.compiler, baseMethodName);
        Node callNode = IR.call(methodCall, IR.thisNode());
        if (arguments != null) {
            callNode.addChildrenToBack(arguments);
        }
        return callNode;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }
}

