/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.engine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.ChildVisibilityAwareElement;
import org.eclipse.e4.ui.css.core.dom.ExtendedCSSRule;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.dom.IStreamingNodeList;
import org.eclipse.e4.ui.css.core.dom.parsers.CSSParser;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyCompositeHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler2Delegate;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.engine.CSSErrorHandler;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedPropertyException;
import org.eclipse.e4.ui.css.core.impl.dom.CSSRuleListImpl;
import org.eclipse.e4.ui.css.core.impl.dom.CSSStyleSheetImpl;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.core.impl.engine.CSSElementContextImpl;
import org.eclipse.e4.ui.css.core.impl.sac.ExtendedSelector;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.eclipse.e4.ui.css.core.resources.ResourceRegistryKeyFactory;
import org.eclipse.e4.ui.css.core.util.impl.resources.ResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class AbstractCSSEngine
implements CSSEngine {
    private static final String ARCHIVE_IDENTIFIER = "!";
    private static final IResourcesLocatorManager defaultResourcesLocatorManager = ResourcesLocatorManager.INSTANCE;
    private ExtendedDocumentCSS documentCSS;
    private ViewCSS viewCSS;
    private IElementProvider elementProvider;
    protected boolean computeDefaultStyle = false;
    private Map<Object, CSSElementContext> elementsContext = null;
    private CSSErrorHandler errorHandler;
    private IResourcesLocatorManager resourcesLocatorManager;
    private IResourcesRegistry resourcesRegistry;
    protected List<ICSSPropertyHandlerProvider> propertyHandlerProviders = new ArrayList<ICSSPropertyHandlerProvider>();
    private Map<ICSSPropertyHandler2, List<ICSSPropertyHandler2>> propertyHandler2InstanceMap = new HashMap<ICSSPropertyHandler2, List<ICSSPropertyHandler2>>();
    private Map<String, String> currentCSSPropertiesApplied;
    private boolean throwError;
    private Map<Object, ICSSValueConverter> valueConverters = null;
    private int parseImport;
    private ResourceRegistryKeyFactory keyFactory;

    public AbstractCSSEngine() {
        this(new DocumentCSSImpl());
    }

    public AbstractCSSEngine(ExtendedDocumentCSS documentCSS) {
        this.documentCSS = documentCSS;
        this.viewCSS = new ViewCSSImpl(documentCSS);
        this.keyFactory = new ResourceRegistryKeyFactory();
    }

    @Override
    public StyleSheet parseStyleSheet(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleSheet(source);
    }

    @Override
    public StyleSheet parseStyleSheet(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleSheet(source);
    }

    @Override
    public StyleSheet parseStyleSheet(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        CSSStyleSheet styleSheet = parser.parseStyleSheet(source);
        CSSRuleList rules = styleSheet.getCssRules();
        int length = rules.getLength();
        CSSRuleListImpl masterList = new CSSRuleListImpl();
        int counter = 0;
        while (counter < length) {
            CSSRule rule = rules.item(counter);
            if (rule.getType() != 3) break;
            CSSImportRule importRule = (CSSImportRule)rule;
            URL url = null;
            if (importRule.getHref().startsWith("platform")) {
                url = FileLocator.resolve((URL)new URL(importRule.getHref()));
            } else {
                String path;
                Path p = new Path(source.getURI());
                IPath trim = p.removeLastSegments(1);
                boolean isArchive = source.getURI().contains(ARCHIVE_IDENTIFIER);
                url = FileLocator.resolve((URL)new URL(String.valueOf(trim.addTrailingSeparator().toString()) + ((CSSImportRule)rule).getHref()));
                File testFile = new File(url.getFile());
                if (!isArchive && !testFile.exists() && (testFile = new File(new URL(path = this.getResourcesLocatorManager().resolve(importRule.getHref())).getFile())).exists()) {
                    url = new URL(path);
                }
            }
            Throwable throwable = null;
            Object var12_15 = null;
            try (InputStream stream = url.openStream();){
                InputSource tempStream = new InputSource();
                tempStream.setURI(url.toString());
                tempStream.setByteStream(stream);
                ++this.parseImport;
                try {
                    styleSheet = (CSSStyleSheet)this.parseStyleSheet(tempStream);
                }
                finally {
                    --this.parseImport;
                }
                CSSRuleList tempRules = styleSheet.getCssRules();
                int j = 0;
                while (j < tempRules.getLength()) {
                    masterList.add(tempRules.item(j));
                    ++j;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++counter;
        }
        int i = counter;
        while (i < length) {
            masterList.add(rules.item(i));
            ++i;
        }
        CSSStyleSheetImpl s = new CSSStyleSheetImpl();
        s.setRuleList(masterList);
        if (this.parseImport == 0) {
            this.documentCSS.addStyleSheet(s);
        }
        return s;
    }

    private void processNodeList(NodeList nodes, BiConsumer<Node, Boolean> consumer, boolean applyStylesToChildNodes) {
        if (nodes instanceof IStreamingNodeList) {
            ((IStreamingNodeList)((Object)nodes)).stream().forEach(child -> consumer.accept((Node)child, applyStylesToChildNodes));
        } else {
            int length = nodes.getLength();
            int k = 0;
            while (k < length) {
                consumer.accept(nodes.item(k), applyStylesToChildNodes);
                ++k;
            }
        }
    }

    private void checkInputSource(InputSource source) throws IOException {
        Reader reader = source.getCharacterStream();
        InputStream stream = source.getByteStream();
        if (reader == null && stream == null) {
            throw new IOException("CharacterStream or ByteStream cannot be null for the InputSource.");
        }
    }

    @Override
    public CSSStyleDeclaration parseStyleDeclaration(String style) throws IOException {
        StringReader reader = new StringReader(style);
        return this.parseStyleDeclaration(reader);
    }

    @Override
    public CSSStyleDeclaration parseStyleDeclaration(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseStyleDeclaration(source);
    }

    @Override
    public CSSStyleDeclaration parseStyleDeclaration(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseStyleDeclaration(source);
    }

    @Override
    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        return parser.parseStyleDeclaration(source);
    }

    @Override
    public SelectorList parseSelectors(String selector) throws IOException {
        StringReader reader = new StringReader(selector);
        return this.parseSelectors(reader);
    }

    @Override
    public SelectorList parseSelectors(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parseSelectors(source);
    }

    @Override
    public SelectorList parseSelectors(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parseSelectors(source);
    }

    @Override
    public SelectorList parseSelectors(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        return parser.parseSelectors(source);
    }

    @Override
    public CSSValue parsePropertyValue(Reader reader) throws IOException {
        InputSource source = new InputSource();
        source.setCharacterStream(reader);
        return this.parsePropertyValue(source);
    }

    @Override
    public CSSValue parsePropertyValue(InputStream stream) throws IOException {
        InputSource source = new InputSource();
        source.setByteStream(stream);
        return this.parsePropertyValue(source);
    }

    @Override
    public CSSValue parsePropertyValue(String value) throws IOException {
        StringReader reader = new StringReader(value);
        return this.parsePropertyValue(reader);
    }

    @Override
    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        this.checkInputSource(source);
        CSSParser parser = this.makeCSSParser();
        return parser.parsePropertyValue(source);
    }

    @Override
    public void applyStyles(Object element, boolean applyStylesToChildNodes) {
        this.applyStyles(element, applyStylesToChildNodes, this.computeDefaultStyle);
    }

    @Override
    public void applyStyles(Object element, boolean applyStylesToChildNodes, boolean computeDefaultStyle) {
        String[] pseudoInstances;
        Element elt = this.getElement(element);
        if (elt == null || !this.isVisible(elt)) {
            return;
        }
        CSSStyleDeclaration style = this.viewCSS.getComputedStyle(elt, null);
        if (computeDefaultStyle) {
            if (applyStylesToChildNodes) {
                this.computeDefaultStyle = computeDefaultStyle;
            }
            this.applyDefaultStyleDeclaration(element, false, style, null);
        }
        if ((pseudoInstances = this.getStaticPseudoInstances(elt)) != null && pseudoInstances.length > 0) {
            String[] stringArray = pseudoInstances;
            int n = pseudoInstances.length;
            int n2 = 0;
            while (n2 < n) {
                String pseudoInstance = stringArray[n2];
                CSSStyleDeclaration styleWithPseudoInstance = this.viewCSS.getComputedStyle(elt, pseudoInstance);
                if (computeDefaultStyle) {
                    this.applyDefaultStyleDeclaration(element, false, styleWithPseudoInstance, pseudoInstance);
                }
                if (styleWithPseudoInstance != null) {
                    CSSRule parentRule = styleWithPseudoInstance.getParentRule();
                    if (parentRule instanceof ExtendedCSSRule) {
                        this.applyConditionalPseudoStyle((ExtendedCSSRule)parentRule, pseudoInstance, element, styleWithPseudoInstance);
                    } else {
                        this.applyStyleDeclaration(elt, styleWithPseudoInstance, pseudoInstance);
                    }
                }
                ++n2;
            }
        }
        if (style != null) {
            this.applyStyleDeclaration(elt, style, null);
        }
        try {
            this.applyInlineStyle(elt, false);
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        if (applyStylesToChildNodes) {
            NodeList nodes;
            NodeList nodeList = nodes = elt instanceof ChildVisibilityAwareElement ? ((ChildVisibilityAwareElement)((Object)elt)).getVisibleChildNodes() : elt.getChildNodes();
            if (nodes != null) {
                this.processNodeList(nodes, this::applyStyles, applyStylesToChildNodes);
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    protected boolean isVisible(Element elt) {
        Node parentNode = elt.getParentNode();
        if (parentNode instanceof ChildVisibilityAwareElement) {
            NodeList l = ((ChildVisibilityAwareElement)((Object)parentNode)).getVisibleChildNodes();
            if (l != null) {
                if (l instanceof IStreamingNodeList) {
                    return ((IStreamingNodeList)((Object)l)).stream().anyMatch(node -> node == elt);
                }
                int length = l.getLength();
                int i = 0;
                while (i < length) {
                    if (l.item(i) == elt) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    private void applyConditionalPseudoStyle(ExtendedCSSRule parentRule, String pseudoInstance, Object element, CSSStyleDeclaration styleWithPseudoInstance) {
        SelectorList selectorList = parentRule.getSelectorList();
        int j = 0;
        while (j < selectorList.getLength()) {
            Selector item = selectorList.item(j);
            ConditionalSelector conditional = null;
            if (item instanceof ConditionalSelector) {
                conditional = (ConditionalSelector)item;
            } else if (item instanceof DescendantSelector) {
                if (((DescendantSelector)item).getSimpleSelector() instanceof ConditionalSelector) {
                    conditional = (ConditionalSelector)((DescendantSelector)item).getSimpleSelector();
                } else if (((DescendantSelector)item).getAncestorSelector() instanceof ConditionalSelector) {
                    conditional = (ConditionalSelector)((DescendantSelector)item).getAncestorSelector();
                }
            }
            if (conditional != null) {
                String value;
                Condition condition = conditional.getCondition();
                AttributeCondition attr = null;
                if (condition instanceof AttributeCondition) {
                    attr = (AttributeCondition)condition;
                } else if (condition instanceof CombinatorCondition) {
                    if (((CombinatorCondition)condition).getSecondCondition() instanceof AttributeCondition) {
                        attr = (AttributeCondition)((CombinatorCondition)condition).getSecondCondition();
                    } else if (((CombinatorCondition)condition).getFirstCondition() instanceof AttributeCondition) {
                        attr = (AttributeCondition)((CombinatorCondition)condition).getFirstCondition();
                    }
                }
                if (attr != null && (value = attr.getValue()).equals(pseudoInstance)) {
                    this.applyStyleDeclaration(element, styleWithPseudoInstance, pseudoInstance);
                    return;
                }
            }
            ++j;
        }
    }

    protected String[] getStaticPseudoInstances(Element element) {
        if (element instanceof CSSStylableElement) {
            CSSStylableElement stylableElement = (CSSStylableElement)element;
            return stylableElement.getStaticPseudoInstances();
        }
        return null;
    }

    protected void onStylesAppliedToChildNodes(Element element, NodeList nodes) {
        if (element instanceof CSSStylableElement) {
            ((CSSStylableElement)element).onStylesApplied(nodes);
        }
    }

    @Override
    public void applyStyleDeclaration(Object element, CSSStyleDeclaration style, String pseudo) {
        boolean avoidanceCacheInstalled;
        boolean bl = avoidanceCacheInstalled = this.currentCSSPropertiesApplied == null;
        if (avoidanceCacheInstalled) {
            this.currentCSSPropertiesApplied = new HashMap<String, String>();
        }
        List handlers2 = Collections.emptyList();
        int i = 0;
        while (i < style.getLength()) {
            block16: {
                String property = style.item(i);
                CSSValue value = style.getPropertyCSSValue(property);
                try {
                    ICSSPropertyHandler handler = this.applyCSSProperty(element, property, value, pseudo);
                    ICSSPropertyHandler2 propertyHandler2 = null;
                    if (handler instanceof ICSSPropertyHandler2) {
                        propertyHandler2 = (ICSSPropertyHandler2)((Object)handler);
                    } else if (handler instanceof ICSSPropertyHandler2Delegate) {
                        propertyHandler2 = ((ICSSPropertyHandler2Delegate)((Object)handler)).getCSSPropertyHandler2();
                    }
                    if (propertyHandler2 == null) break block16;
                    switch (handlers2.size()) {
                        case 0: {
                            handlers2 = this.propertyHandler2InstanceMap.computeIfAbsent(propertyHandler2, Collections::singletonList);
                            break;
                        }
                        case 1: {
                            handlers2 = new ArrayList(handlers2);
                            handlers2.add(propertyHandler2);
                            break;
                        }
                        default: {
                            if (!handlers2.contains(propertyHandler2)) {
                                handlers2.add(propertyHandler2);
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) break block16;
                    this.handleExceptions(e);
                }
            }
            ++i;
        }
        for (ICSSPropertyHandler2 handler2 : handlers2) {
            try {
                handler2.onAllCSSPropertiesApplyed(element, this, pseudo);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        if (avoidanceCacheInstalled) {
            this.currentCSSPropertiesApplied = null;
        }
    }

    @Override
    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, Reader reader) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(reader);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    @Override
    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputStream stream) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(stream);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    @Override
    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, InputSource source) throws IOException {
        CSSStyleDeclaration style = this.parseStyleDeclaration(source);
        this.applyStyleDeclaration(node, style, null);
        return style;
    }

    @Override
    public CSSStyleDeclaration parseAndApplyStyleDeclaration(Object node, String style) throws IOException {
        CSSStyleDeclaration styleDeclaration = this.parseStyleDeclaration(style);
        this.applyStyleDeclaration(node, styleDeclaration, null);
        return styleDeclaration;
    }

    @Override
    public void applyInlineStyle(Object node, boolean applyStylesToChildNodes) {
        Element elt = this.getElement(node);
        if (elt != null) {
            NodeList nodes;
            CSSStylableElement stylableElement;
            String style;
            if (elt instanceof CSSStylableElement && (style = (stylableElement = (CSSStylableElement)elt).getCSSStyle()) != null && style.length() > 0) {
                try {
                    this.parseAndApplyStyleDeclaration(stylableElement.getNativeWidget(), style);
                }
                catch (IOException e) {
                    this.handleExceptions(e);
                }
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                this.processNodeList(nodes, this::applyInlineStyle, applyStylesToChildNodes);
            }
        }
    }

    @Override
    public CSSStyleDeclaration getDefaultStyleDeclaration(Object element, String pseudoE) {
        return this.getDefaultStyleDeclaration(element, null, pseudoE);
    }

    public CSSStyleDeclaration getDefaultStyleDeclaration(Object widget, CSSStyleDeclaration newStyle, String pseudoE) {
        CSSStyleDeclaration style = null;
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            try {
                style = provider.getDefaultCSSStyleDeclaration(this, widget, newStyle, pseudoE);
            }
            catch (Exception e) {
                this.handleExceptions(e);
            }
        }
        return style;
    }

    @Override
    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes) {
        this.applyDefaultStyleDeclaration(element, applyStylesToChildNodes, null, null);
    }

    public void applyDefaultStyleDeclaration(Object element, boolean applyStylesToChildNodes, CSSStyleDeclaration newStyle, String pseudoE) {
        Element elt = this.getElement(element);
        if (elt != null) {
            NodeList nodes;
            if (elt instanceof CSSStylableElement) {
                CSSStylableElement stylableElement = (CSSStylableElement)elt;
                CSSStyleDeclaration oldDefaultStyleDeclaration = stylableElement.getDefaultStyleDeclaration(pseudoE);
                CSSStyleDeclaration defaultStyleDeclaration = this.getDefaultStyleDeclaration(element, newStyle, pseudoE);
                if (oldDefaultStyleDeclaration != null) {
                    try {
                        this.throwError = false;
                        this.applyStyleDeclaration(element, defaultStyleDeclaration, pseudoE);
                    }
                    finally {
                        this.throwError = true;
                    }
                }
            }
            if (applyStylesToChildNodes && (nodes = elt.getChildNodes()) != null) {
                this.processNodeList(nodes, this::applyDefaultStyleDeclaration, applyStylesToChildNodes);
                this.onStylesAppliedToChildNodes(elt, nodes);
            }
        }
    }

    @Override
    public ICSSPropertyHandler applyCSSProperty(Object element, String property, CSSValue value, String pseudo) throws Exception {
        if (this.currentCSSPropertiesApplied != null && this.currentCSSPropertiesApplied.containsKey(property)) {
            return null;
        }
        element = this.getElement(element);
        if ("inherit".equals(value.getCssText())) {
            Element actualElement = (Element)element;
            Node parentNode = actualElement.getParentNode();
            String parentValueString = this.retrieveCSSProperty(parentNode, property, pseudo);
            value = this.parsePropertyValue(parentValueString);
        }
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            Collection<ICSSPropertyHandler> handlers = provider.getCSSPropertyHandlers(element, property);
            if (handlers == null) continue;
            for (ICSSPropertyHandler handler : handlers) {
                try {
                    boolean result = handler.applyCSSProperty(element, property, value, pseudo, this);
                    if (!result) continue;
                    if (this.currentCSSPropertiesApplied != null) {
                        this.currentCSSPropertiesApplied.put(property, property);
                    }
                    return handler;
                }
                catch (Exception e) {
                    if (!this.throwError && (this.throwError || e instanceof UnsupportedPropertyException)) continue;
                    this.handleExceptions(e);
                }
            }
        }
        return null;
    }

    @Override
    public String retrieveCSSProperty(Object element, String property, String pseudo) {
        try {
            element = this.getElement(element);
            for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
                Collection<ICSSPropertyHandler> handlers = provider.getCSSPropertyHandlers(element, property);
                if (handlers == null) continue;
                for (ICSSPropertyHandler handler : handlers) {
                    String value = handler.retrieveCSSProperty(element, property, pseudo, this);
                    if (StringUtils.isEmpty(value)) continue;
                    return value;
                }
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    @Override
    public String[] getCSSCompositePropertiesNames(String property) {
        Collection<ICSSPropertyHandler> handlers;
        block4: {
            handlers = this.getCSSPropertyHandlers(property);
            if (handlers != null) break block4;
            return null;
        }
        try {
            for (ICSSPropertyHandler handler : handlers) {
                ICSSPropertyCompositeHandler compositeHandler;
                if (!(handler instanceof ICSSPropertyCompositeHandler) || !(compositeHandler = (ICSSPropertyCompositeHandler)handler).isCSSPropertyComposite(property)) continue;
                return compositeHandler.getCSSPropertiesNames(property);
            }
        }
        catch (Exception e) {
            this.handleExceptions(e);
        }
        return null;
    }

    protected Collection<ICSSPropertyHandler> getCSSPropertyHandlers(String property) throws Exception {
        Collection<ICSSPropertyHandler> handlers = new ArrayList<ICSSPropertyHandler>();
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            Collection<ICSSPropertyHandler> h = provider.getCSSPropertyHandlers(property);
            if (handlers == null) {
                handlers = h;
                continue;
            }
            handlers = new ArrayList<ICSSPropertyHandler>(handlers);
            handlers.addAll(h);
        }
        return handlers;
    }

    @Override
    public Collection<String> getCSSProperties(Object element) {
        HashSet<String> properties = new HashSet<String>();
        for (ICSSPropertyHandlerProvider provider : this.propertyHandlerProviders) {
            properties.addAll(provider.getCSSProperties(element));
        }
        return properties;
    }

    @Override
    public IElementProvider getElementProvider() {
        return this.elementProvider;
    }

    @Override
    public void setElementProvider(IElementProvider elementProvider) {
        this.elementProvider = elementProvider;
    }

    @Override
    public Element getElement(Object element) {
        Element elt = null;
        if (element == null) {
            return elt;
        }
        CSSElementContext elementContext = this.getCSSElementContext(element);
        if (elementContext != null && !elementContext.elementMustBeRefreshed(this.elementProvider)) {
            return elementContext.getElement();
        }
        if (element instanceof Element) {
            elt = (Element)element;
        } else if (this.elementProvider != null) {
            elt = this.elementProvider.getElement(element, this);
        }
        if (elt != null) {
            if (elementContext == null) {
                elementContext = new CSSElementContextImpl();
                Object nativeWidget = this.getNativeWidget(element);
                this.hookNativeWidget(nativeWidget);
                this.getElementsContext().put(nativeWidget, elementContext);
            }
            elementContext.setElementProvider(this.elementProvider);
            elementContext.setElement(elt);
            if (elt instanceof CSSStylableElement) {
                ((CSSStylableElement)elt).initialize();
            }
        }
        return elt;
    }

    protected void hookNativeWidget(Object widget) {
    }

    @Override
    public void handleWidgetDisposed(Object widget) {
        if (this.elementsContext != null) {
            this.elementsContext.remove(widget);
        }
    }

    public Object getDocument() {
        return null;
    }

    @Override
    public CSSElementContext getCSSElementContext(Object element) {
        Object o = this.getNativeWidget(element);
        return this.getElementsContext().get(o);
    }

    public Object getNativeWidget(Object element) {
        Object o = element;
        if (element instanceof CSSStylableElement) {
            o = ((CSSStylableElement)o).getNativeWidget();
        }
        return o;
    }

    protected Map<Object, CSSElementContext> getElementsContext() {
        if (this.elementsContext == null) {
            this.elementsContext = new HashMap<Object, CSSElementContext>();
        }
        return this.elementsContext;
    }

    @Override
    public boolean matches(Selector selector, Object element, String pseudoElt) {
        Element elt = this.getElement(element);
        if (elt == null) {
            return false;
        }
        if (selector instanceof ExtendedSelector) {
            ExtendedSelector extendedSelector = (ExtendedSelector)selector;
            return extendedSelector.match(elt, pseudoElt);
        }
        return false;
    }

    @Override
    public void handleExceptions(Exception e) {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    @Override
    public CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(CSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public IResourcesLocatorManager getResourcesLocatorManager() {
        if (this.resourcesLocatorManager == null) {
            return defaultResourcesLocatorManager;
        }
        return this.resourcesLocatorManager;
    }

    @Override
    public void setResourcesLocatorManager(IResourcesLocatorManager resourcesLocatorManager) {
        this.resourcesLocatorManager = resourcesLocatorManager;
    }

    @Override
    public DocumentCSS getDocumentCSS() {
        return this.documentCSS;
    }

    @Override
    public ViewCSS getViewCSS() {
        return this.viewCSS;
    }

    @Override
    public void dispose() {
        this.reset();
        Collection<CSSElementContext> contexts = this.elementsContext.values();
        for (CSSElementContext context : contexts) {
            Element element = context.getElement();
            if (!(element instanceof CSSStylableElement)) continue;
            ((CSSStylableElement)element).dispose();
        }
        this.elementsContext = null;
        if (this.resourcesRegistry != null) {
            this.resourcesRegistry.dispose();
        }
    }

    @Override
    public void reset() {
        this.documentCSS.removeAllStyleSheets();
    }

    @Override
    public IResourcesRegistry getResourcesRegistry() {
        return this.resourcesRegistry;
    }

    @Override
    public void setResourcesRegistry(IResourcesRegistry resourcesRegistry) {
        this.resourcesRegistry = resourcesRegistry;
    }

    public void registerCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.add(handlerProvider);
    }

    public void unregisterCSSPropertyHandlerProvider(ICSSPropertyHandlerProvider handlerProvider) {
        this.propertyHandlerProviders.remove(handlerProvider);
    }

    @Override
    public void registerCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            this.valueConverters = new HashMap<Object, ICSSValueConverter>();
        }
        this.valueConverters.put(converter.getToType(), converter);
    }

    @Override
    public void unregisterCSSValueConverter(ICSSValueConverter converter) {
        if (this.valueConverters == null) {
            return;
        }
        this.valueConverters.remove(converter);
    }

    @Override
    public ICSSValueConverter getCSSValueConverter(Object toType) {
        if (this.valueConverters != null) {
            return this.valueConverters.get(toType);
        }
        return null;
    }

    @Override
    public Object convert(CSSValue value, Object toType, Object context) throws Exception {
        ICSSValueConverter converter;
        if ("unset".equals(value.getCssText())) {
            return null;
        }
        Object key = this.keyFactory.createKey(value);
        Object newValue = this.getResource(toType, key);
        if (newValue == null && (converter = this.getCSSValueConverter(toType)) != null) {
            newValue = converter.convert(value, (CSSEngine)this, context);
            this.registerResource(toType, key, newValue);
        }
        return newValue;
    }

    private Object getResource(Object toType, Object key) {
        if (key != null && this.getResourcesRegistry() != null) {
            return this.getResourcesRegistry().getResource(toType, key);
        }
        return null;
    }

    private void registerResource(Object toType, Object key, Object resource) {
        if (key != null && resource != null && this.getResourcesRegistry() != null) {
            this.getResourcesRegistry().registerResource(toType, key, resource);
        }
    }

    @Override
    public String convert(Object value, Object toType, Object context) throws Exception {
        if (value == null) {
            return null;
        }
        ICSSValueConverter converter = this.getCSSValueConverter(toType);
        if (converter != null) {
            return converter.convert(value, (CSSEngine)this, context);
        }
        return null;
    }

    public abstract CSSParser makeCSSParser();

    protected void setResourceRegistryKeyFactory(ResourceRegistryKeyFactory keyFactory) {
        this.keyFactory = keyFactory;
    }
}

