/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.tools;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextWithImage
extends Composite {
    private final Text fText;
    private final Label fLabel;
    private Image fImage;

    public TextWithImage(Composite parent, int style) {
        super(parent, 2048);
        Color backgroundColor = Display.getDefault().getSystemColor(25);
        this.setBackground(backgroundColor);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 1;
        this.setLayout((Layout)gridLayout);
        this.fLabel = new Label((Composite)this, 0);
        this.fLabel.setBackground(backgroundColor);
        if (this.fImage != null) {
            this.setImage(this.fImage);
        }
        this.fText = new Text((Composite)this, 0);
        this.fText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    public void dispose() {
        this.fImage = null;
        super.dispose();
    }

    public Text getTextElement() {
        return this.fText;
    }

    public void setImage(Image image) {
        this.fImage = image;
        if (this.fLabel != null && !this.fLabel.isDisposed()) {
            this.fLabel.setImage(this.fImage);
            this.fLabel.setVisible(this.fImage != null);
        }
    }

    public String getText() {
        return this.getTextElement().getText();
    }

    public void setText(String string) {
        this.getTextElement().setText(string);
    }
}

