/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ExportProjectSetLocationPage
extends TeamWizardPage {
    Combo fileCombo;
    protected IFile workspaceFile;
    protected String file = "";
    Button browseButton;
    private boolean saveToFileSystem;
    private Button fileRadio;
    private Button workspaceRadio;
    protected Text workspaceText;

    public ExportProjectSetLocationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TeamUIMessages.ExportProjectSetMainPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        Group locationGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        locationGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        locationGroup.setLayoutData((Object)data);
        locationGroup.setText(TeamUIMessages.ExportProjectSetMainPage_Project_Set_File_Name__3);
        this.createExportToFile((Composite)locationGroup);
        this.createExportToWorkspace((Composite)locationGroup);
        this.saveToFileSystem = true;
        this.setControl((Control)composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createExportToFile(Composite composite) {
        this.fileRadio = new Button(composite, 16);
        this.fileRadio.setText(TeamUIMessages.ExportProjectSetMainPage_FileButton);
        this.fileRadio.addListener(13, event -> {
            this.saveToFileSystem = true;
            this.file = this.fileCombo.getText();
            this.updateEnablement();
        });
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        inner.setLayoutData((Object)data);
        this.fileCombo = this.createDropDownCombo(inner);
        this.file = PsfFilenameStore.getInstance().getSuggestedDefault();
        this.fileCombo.setItems(PsfFilenameStore.getInstance().getHistory());
        this.fileCombo.setText(this.file);
        this.fileCombo.addListener(24, event -> {
            this.file = this.fileCombo.getText();
            this.updateEnablement();
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(TeamUIMessages.ExportProjectSetMainPage_Browse_4);
        data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, event -> {
            int separator;
            if (!this.isSaveToFileSystem()) {
                this.saveToFileSystem = true;
            }
            FileDialog d = new FileDialog(this.getShell(), 8192);
            d.setFilterExtensions(new String[]{"*.psf"});
            d.setFilterNames(new String[]{TeamUIMessages.ExportProjectSetMainPage_Project_Set_Files_3});
            d.setFileName(TeamUIMessages.ExportProjectSetMainPage_default);
            String fileName = this.getFileName();
            if (fileName != null && (separator = fileName.lastIndexOf(File.separatorChar)) != -1) {
                fileName = fileName.substring(0, separator);
            }
            d.setFilterPath(fileName);
            String f = d.open();
            if (f != null) {
                this.fileCombo.setText(f);
                this.file = f;
            }
        });
    }

    private void createExportToWorkspace(Composite composite) {
        this.workspaceRadio = new Button(composite, 16);
        this.workspaceRadio.setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceButton);
        this.workspaceRadio.addListener(13, event -> {
            this.saveToFileSystem = false;
            this.updateEnablement();
        });
        Composite nameGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        nameGroup.setLayoutData((Object)data);
        this.workspaceText = this.createTextField(nameGroup);
        this.workspaceText.setEditable(false);
        this.workspaceText.addListener(24, event -> {
            this.file = this.workspaceFile.getLocation().toString();
            this.updateEnablement();
        });
        Button wsBrowseButton = new Button(nameGroup, 8);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, wsBrowseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        wsBrowseButton.setLayoutData((Object)gd);
        wsBrowseButton.setText(TeamUIMessages.ExportProjectSetMainPage_Browse);
        wsBrowseButton.addListener(13, event -> {
            if (this.isSaveToFileSystem()) {
                this.saveToFileSystem = false;
            }
            WorkspaceDialog d = new WorkspaceDialog(this.getShell());
            d.open();
        });
    }

    private void updateEnablement() {
        boolean complete;
        this.fileRadio.setSelection(this.saveToFileSystem);
        this.workspaceRadio.setSelection(!this.saveToFileSystem);
        if (this.file.length() == 0) {
            this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_specifyFile);
            complete = false;
        } else {
            File f = new File(this.file);
            if (f.isDirectory()) {
                this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_You_have_specified_a_folder_5);
                complete = false;
            } else if (!this.isSaveToFileSystem() && this.workspaceFile == null) {
                this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_specifyFile);
                complete = false;
            } else {
                complete = true;
            }
        }
        if (!this.isSaveToFileSystem() && this.workspaceFile != null) {
            complete = true;
        }
        if (complete) {
            this.setErrorMessage(null);
            this.setDescription(TeamUIMessages.ExportProjectSetMainPage_description);
        }
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileCombo.setFocus();
        }
    }

    public boolean isSaveToFileSystem() {
        return this.saveToFileSystem;
    }

    public void refreshWorkspaceFile(IProgressMonitor monitor) throws CoreException {
        if (this.workspaceFile != null) {
            this.workspaceFile.refreshLocal(1, monitor);
        }
    }

    public String getFileName() {
        return this.file;
    }

    public void setFileName(String file) {
        if (file != null) {
            this.file = file;
        }
    }

    public void validateEditWorkspaceFile(Shell shell) throws TeamException {
        if (this.workspaceFile == null || !this.workspaceFile.exists() || !this.workspaceFile.isReadOnly()) {
            return;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{this.workspaceFile}, (Object)shell);
        if (!status.isOK()) {
            throw new TeamException(status);
        }
    }

    class LocationPageContentProvider
    extends BaseWorkbenchContentProvider {
        boolean showClosedProjects = false;

        LocationPageContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                Object[] objectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object project = objectArray[n2];
                    if (project.isOpen()) {
                        accessibleProjects.add(project);
                    }
                    ++n2;
                }
                return accessibleProjects.toArray();
            }
            return super.getChildren(element);
        }
    }

    class WorkspaceDialog
    extends TitleAreaDialog {
        protected TreeViewer wsTreeViewer;
        protected Text wsFilenameText;
        protected IContainer wsContainer;
        protected Image dlgTitleImage;
        private Button okButton;

        public WorkspaceDialog(Shell shell) {
            super(shell);
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.setTitle(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogTitle);
            this.setMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogTitleMessage);
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, false);
            composite.setLayoutData((Object)data);
            this.getShell().setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogMessage);
            this.wsTreeViewer = new TreeViewer(composite, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 550;
            gd.heightHint = 250;
            this.wsTreeViewer.getTree().setLayoutData((Object)gd);
            this.wsTreeViewer.setContentProvider((IContentProvider)new LocationPageContentProvider());
            this.wsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.wsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            Composite group = new Composite(composite, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            Label label = new Label(group, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogFilename);
            this.wsFilenameText = new Text(group, 2048);
            this.wsFilenameText.setLayoutData((Object)new GridData(4, 128, true, false));
            this.wsFilenameText.setText("projectSet.psf");
            this.setupListeners();
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.okButton = this.getButton(0);
        }

        protected void okPressed() {
            if (this.wsContainer == null) {
                this.getSelectedContainer();
            }
            ExportProjectSetLocationPage.this.workspaceFile = this.wsContainer.getFile((IPath)new Path(this.wsFilenameText.getText()));
            if (ExportProjectSetLocationPage.this.workspaceFile != null) {
                ExportProjectSetLocationPage.this.workspaceText.setText(ExportProjectSetLocationPage.this.workspaceFile.getFullPath().toString());
            }
            super.okPressed();
        }

        private void getSelectedContainer() {
            Object obj = this.wsTreeViewer.getStructuredSelection().getFirstElement();
            if (obj instanceof IContainer) {
                this.wsContainer = (IContainer)obj;
            } else if (obj instanceof IFile) {
                this.wsContainer = ((IFile)obj).getParent();
            }
        }

        protected void cancelPressed() {
            this.getSelectedContainer();
            super.cancelPressed();
        }

        public boolean close() {
            return super.close();
        }

        void setupListeners() {
            this.wsTreeViewer.addSelectionChangedListener(event -> {
                IStructuredSelection s = event.getStructuredSelection();
                Object obj = s.getFirstElement();
                if (obj instanceof IContainer) {
                    this.wsContainer = (IContainer)obj;
                } else if (obj instanceof IFile) {
                    IFile tempFile = (IFile)obj;
                    this.wsContainer = tempFile.getParent();
                    this.wsFilenameText.setText(tempFile.getName());
                }
            });
            this.wsTreeViewer.addDoubleClickListener(event -> {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)s).getFirstElement();
                    if (this.wsTreeViewer.getExpandedState(item)) {
                        this.wsTreeViewer.collapseToLevel(item, 1);
                    } else {
                        this.wsTreeViewer.expandToLevel(item, 1);
                    }
                }
            });
            this.wsFilenameText.addModifyListener(e -> {
                String patchName = this.wsFilenameText.getText();
                if (patchName.trim().isEmpty()) {
                    this.okButton.setEnabled(false);
                    this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogErrorNoFilename);
                } else if (!ResourcesPlugin.getWorkspace().validateName(patchName, 1).isOK()) {
                    this.okButton.setEnabled(false);
                    this.setErrorMessage(TeamUIMessages.ExportProjectSetMainPage_WorkspaceDialogErrorFilenameSegments);
                } else {
                    this.okButton.setEnabled(true);
                    this.setErrorMessage(null);
                }
            });
        }
    }
}

