/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.base;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;

public final class FlameDefaultPalette {
    private static final int NUM_COLORS = 360;
    private static final @NonNull Map<@NonNull String, @NonNull OutputElementStyle> STYLES;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static {
        RotatingPaletteProvider palette = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        int i = 0;
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull @NonNull ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RGBAColor color : palette.get()) {
            builder.put((Object)String.valueOf(i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)X11ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()))));
            ++i;
        }
        STYLES = builder.build();
    }

    private FlameDefaultPalette() {
    }

    public static @NonNull Map<@NonNull String, @NonNull OutputElementStyle> getStyles() {
        return STYLES;
    }

    public static OutputElementStyle getStyleFor(Object callsite) {
        int index = Math.abs(31 * callsite.hashCode()) % 360;
        return Objects.requireNonNull(STYLES.get(String.valueOf(index)));
    }
}

