/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.colors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.xml.TmfFilterContentHandler;
import org.eclipse.tracecompass.tmf.core.filter.xml.TmfFilterXMLWriter;
import org.eclipse.tracecompass.tmf.ui.views.colors.ColorSetting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ColorSettingsXML {
    private static final String COLOR_SETTINGS_TAG = "COLOR_SETTINGS";
    private static final String COLOR_SETTING_TAG = "COLOR_SETTING";
    private static final String FG_TAG = "FG";
    private static final String BG_TAG = "BG";
    private static final String R_ATTR = "R";
    private static final String G_ATTR = "G";
    private static final String B_ATTR = "B";
    private static final String TICK_TAG = "TICK";
    private static final String FILTER_TAG = "FILTER";

    public static void save(String pathName, ColorSetting[] colorSettings) {
        try {
            DocumentBuilder documentBuilder = XmlUtils.newSafeDocumentBuilderFactory().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(COLOR_SETTINGS_TAG);
            document.appendChild(rootElement);
            ColorSetting[] colorSettingArray = colorSettings;
            int n = colorSettings.length;
            int n2 = 0;
            while (n2 < n) {
                RGB background;
                ColorSetting colorSetting = colorSettingArray[n2];
                Element colorSettingElement = document.createElement(COLOR_SETTING_TAG);
                rootElement.appendChild(colorSettingElement);
                RGB foreground = colorSetting.getForegroundRGB();
                if (foreground != null) {
                    Element fgElement = document.createElement(FG_TAG);
                    colorSettingElement.appendChild(fgElement);
                    ColorSettingsXML.setElementColor(fgElement, foreground);
                }
                if ((background = colorSetting.getBackgroundRGB()) != null) {
                    Element bgElement = document.createElement(BG_TAG);
                    colorSettingElement.appendChild(bgElement);
                    ColorSettingsXML.setElementColor(bgElement, background);
                }
                Element tickColorElement = document.createElement(TICK_TAG);
                colorSettingElement.appendChild(tickColorElement);
                RGB tickColor = colorSetting.getTickColorRGB();
                ColorSettingsXML.setElementColor(tickColorElement, tickColor);
                ITmfFilterTreeNode filter = colorSetting.getFilter();
                if (filter != null) {
                    Element filterElement = document.createElement(FILTER_TAG);
                    colorSettingElement.appendChild(filterElement);
                    TmfFilterXMLWriter.buildXMLTree((Document)document, (ITmfFilterTreeNode)filter, (Element)filterElement);
                }
                ++n2;
            }
            Transformer transformer = XmlUtils.newSecureTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(pathName));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | TransformerException e) {
            Activator.getDefault().logError("Error saving color xml file: " + pathName, e);
        }
    }

    private static void setElementColor(Element element, RGB rgb) {
        element.setAttribute(R_ATTR, Integer.toString(rgb.red));
        element.setAttribute(G_ATTR, Integer.toString(rgb.green));
        element.setAttribute(B_ATTR, Integer.toString(rgb.blue));
    }

    /*
     * Unable to fully structure code
     */
    public static ColorSetting[] load(String pathName) {
        if (!new File(pathName).canRead()) {
            return new ColorSetting[0];
        }
        parserFactory = SAXParserFactory.newInstance();
        try {
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException | SAXException e) {
            Activator.getDefault().logError("Error setting XML parser's FEATURE_SECURE_PROCESSING; continuing", e);
        }
        parserFactory.setNamespaceAware(true);
        handler = new ColorSettingsContentHandler();
        try {
            saxReader = parserFactory.newSAXParser().getXMLReader();
            saxReader.setContentHandler(handler);
            saxReader.parse(pathName);
            return ColorSettingsContentHandler.access$1(handler).toArray(new ColorSetting[0]);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.getDefault().logError("Error loading color xml file: " + pathName, e);
            ** for (colorSetting : ColorSettingsContentHandler.access$1((ColorSettingsContentHandler)handler))
        }
lbl-1000:
        // 1 sources

        {
            colorSetting.dispose();
            continue;
        }
lbl21:
        // 1 sources

        return new ColorSetting[0];
    }

    private static final class ColorSettingsContentHandler
    extends DefaultHandler {
        private List<ColorSetting> colorSettings = new ArrayList<ColorSetting>(0);
        private RGB fg;
        private RGB bg;
        private RGB tickColor;
        private ITmfFilterTreeNode filter;
        private TmfFilterContentHandler filterContentHandler;

        private ColorSettingsContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (localName) {
                case "COLOR_SETTINGS": {
                    this.colorSettings = new ArrayList<ColorSetting>();
                    break;
                }
                case "COLOR_SETTING": {
                    this.fg = null;
                    this.bg = null;
                    this.tickColor = null;
                    this.filter = null;
                    break;
                }
                case "FG": {
                    this.fg = ColorSettingsContentHandler.getRGBfromAttributes(attributes);
                    break;
                }
                case "BG": {
                    this.bg = ColorSettingsContentHandler.getRGBfromAttributes(attributes);
                    break;
                }
                case "TICK": {
                    this.tickColor = ColorSettingsContentHandler.getRGBfromAttributes(attributes);
                    break;
                }
                case "FILTER": {
                    this.filterContentHandler = new TmfFilterContentHandler();
                    break;
                }
                default: {
                    if (this.filterContentHandler == null) break;
                    this.filterContentHandler.startElement(uri, localName, qName, attributes);
                }
            }
        }

        private static RGB getRGBfromAttributes(Attributes attributes) {
            int r = Integer.parseInt(attributes.getValue(ColorSettingsXML.R_ATTR));
            int g = Integer.parseInt(attributes.getValue(ColorSettingsXML.G_ATTR));
            int b = Integer.parseInt(attributes.getValue(ColorSettingsXML.B_ATTR));
            return new RGB(r, g, b);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!localName.equals(ColorSettingsXML.COLOR_SETTINGS_TAG)) {
                if (localName.equals(ColorSettingsXML.COLOR_SETTING_TAG)) {
                    ColorSetting colorSetting = new ColorSetting(this.fg, this.bg, this.tickColor, this.filter);
                    this.colorSettings.add(colorSetting);
                } else if (localName.equals(ColorSettingsXML.FILTER_TAG)) {
                    this.filter = this.filterContentHandler.getTree();
                    this.filterContentHandler = null;
                } else if (this.filterContentHandler != null) {
                    this.filterContentHandler.endElement(uri, localName, qName);
                }
            }
        }

        static /* synthetic */ List access$1(ColorSettingsContentHandler colorSettingsContentHandler) {
            return colorSettingsContentHandler.colorSettings;
        }
    }
}

