/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.ContributionRoot;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IMenuService;

public class ContributionFactoryGenerator
extends ContextFunction {
    private AbstractContributionFactory factoryImpl;
    private IConfigurationElement configElement;
    private int type;

    public ContributionFactoryGenerator(AbstractContributionFactory factory, int type) {
        this.factoryImpl = factory;
        this.type = type;
    }

    public ContributionFactoryGenerator(IConfigurationElement element, int type) {
        this.configElement = element;
        this.type = type;
    }

    private AbstractContributionFactory getFactory() {
        if (this.factoryImpl == null && this.configElement != null) {
            try {
                this.factoryImpl = (AbstractContributionFactory)this.configElement.createExecutableExtension("class");
            }
            catch (CoreException e) {
                WorkbenchPlugin.log(e);
                return null;
            }
        }
        return this.factoryImpl;
    }

    public Object compute(IEclipseContext context, String contextKey) {
        AbstractContributionFactory factory = this.getFactory();
        IMenuService menuService = (IMenuService)context.get(IMenuService.class);
        ContributionRoot root = new ContributionRoot(menuService, new HashSet(), null, factory);
        ServiceLocator sl = new ServiceLocator();
        sl.setContext(context);
        factory.createContributionItems(sl, root);
        List<IContributionItem> contributionItems = root.getItems();
        Map<IContributionItem, Expression> itemsToExpression = root.getVisibleWhen();
        ArrayList<MUIElement> menuElements = new ArrayList<MUIElement>();
        for (IContributionItem obj : contributionItems) {
            IContributionItem ici;
            MUIElement opaqueItem;
            if (!(obj instanceof IContributionItem) || (opaqueItem = this.createUIElement(ici = obj)) == null) continue;
            if (itemsToExpression.containsKey(ici)) {
                Expression ex = itemsToExpression.get(ici);
                MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
                exp.setCoreExpressionId("programmatic." + ici.getId());
                exp.setCoreExpression((Object)ex);
                opaqueItem.setVisibleWhen((MExpression)exp);
            }
            menuElements.add(opaqueItem);
        }
        context.set(List.class, menuElements);
        return () -> root.release();
    }

    private MUIElement createUIElement(IContributionItem ici) {
        switch (this.type) {
            case 0: {
                return this.createMenuItem(ici);
            }
            case 1: {
                return this.createToolItem(ici);
            }
        }
        return null;
    }

    private MUIElement createMenuItem(IContributionItem ici) {
        MMenuItem opaqueItem = OpaqueElementUtil.createOpaqueMenuItem();
        opaqueItem.setElementId(ici.getId());
        OpaqueElementUtil.setOpaqueItem((MUIElement)opaqueItem, (Object)ici);
        return opaqueItem;
    }

    private MUIElement createToolItem(IContributionItem ici) {
        MToolItem opaqueItem = OpaqueElementUtil.createOpaqueToolItem();
        opaqueItem.setElementId(ici.getId());
        OpaqueElementUtil.setOpaqueItem((MUIElement)opaqueItem, (Object)ici);
        return opaqueItem;
    }
}

