/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;

public class ClasspathFile
extends ClasspathLocation {
    protected File file;
    protected Hashtable packageCache;
    String packageName;
    protected char[] normalizedPath;
    String encoding;
    HashtableOfObject[] definedItems = new HashtableOfObject[16];
    NameEnvironmentAnswer foundAnswer;

    public ClasspathFile(File file, String encoding, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.packageName = file.getName();
        this.encoding = encoding;
    }

    @Override
    public NameEnvironmentAnswer findBinding(char[] typeName, String qualifiedPackageName, int type, ITypeRequestor requestor) {
        if (this.foundAnswer == null) {
            this.parseFile(requestor);
        }
        NameEnvironmentAnswer answer = null;
        if ((type & 3) != 0 && (answer = (NameEnvironmentAnswer)this.definedItems[3].get(typeName)) != null) {
            return answer;
        }
        if ((type & 4) != 0 && (answer = (NameEnvironmentAnswer)this.definedItems[4].get(typeName)) != null) {
            return answer;
        }
        if ((type & 8) != 0 && (answer = (NameEnvironmentAnswer)this.definedItems[8].get(typeName)) != null) {
            return answer;
        }
        return null;
    }

    private void parseFile(ITypeRequestor requestor) {
        CompilationUnit compilationUnit = new CompilationUnit(null, this.file.getAbsolutePath(), this.encoding);
        compilationUnit.packageName = new char[][]{this.packageName.toCharArray()};
        int i = 0;
        while (i < this.definedItems.length) {
            this.definedItems[i] = new HashtableOfObject();
            ++i;
        }
        this.foundAnswer = new NameEnvironmentAnswer(compilationUnit, this.fetchAccessRestriction(this.file.getAbsolutePath()));
        if (requestor != null) {
            CompilationUnitDeclaration declaration = requestor.doParse(compilationUnit, null);
            int i2 = 0;
            while (i2 < declaration.statements.length) {
                if (declaration.statements[i2] instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration method = (AbstractMethodDeclaration)declaration.statements[i2];
                    this.definedItems[8].put(method.getName(), this.foundAnswer);
                } else if (declaration.statements[i2] instanceof AbstractVariableDeclaration) {
                    AbstractVariableDeclaration var = (AbstractVariableDeclaration)declaration.statements[i2];
                    this.definedItems[3].put(var.name, this.foundAnswer);
                }
                ++i2;
            }
            int inx = 0;
            while (inx < declaration.numberInferredTypes) {
                InferredType inferredType = declaration.inferredTypes[inx];
                if (inferredType.isDefinition()) {
                    this.definedItems[4].put(inferredType.getName(), this.foundAnswer);
                }
                ++inx;
            }
        } else {
            throw new UnimplementedException();
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        throw new UnimplementedException();
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String qualifiedPackageName) {
        return this.packageName.equals(qualifiedPackageName);
    }

    @Override
    public void reset() {
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for file " + this.file.getPath();
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] rawName = this.file.getPath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public char[][][] findTypeNames(String qualifiedPackageName) {
        throw new UnimplementedException("implement");
    }
}

