/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public final class PGPSignatureVerifier
extends ProcessingStep {
    public static final String ID = "org.eclipse.equinox.p2.processing.PGPSignatureCheck";
    public static final String PGP_SIGNER_KEYS_PROPERTY_NAME = "pgp.publicKeys";
    public static final String PGP_SIGNATURES_PROPERTY_NAME = "pgp.signatures";
    private List<PGPSignature> signaturesToVerify;

    public PGPSignatureVerifier() {
        this.link(PGPSignatureVerifier.nullOutputStream(), (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        super.initialize(agent, descriptor, context);
        String signatureText = this.unnormalizedPGPProperty(context.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
        if (signatureText == null) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        this.signaturesToVerify = new ArrayList<PGPSignature>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ArmoredInputStream in = new ArmoredInputStream((InputStream)new ByteArrayInputStream(signatureText.getBytes()));){
                PGPSignatureList signatureList;
                JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory((InputStream)in);
                Object o = pgpFactory.nextObject();
                if (o instanceof PGPCompressedData) {
                    PGPCompressedData pgpCompressData = (PGPCompressedData)o;
                    pgpFactory = new JcaPGPObjectFactory(pgpCompressData.getDataStream());
                    signatureList = (PGPSignatureList)pgpFactory.nextObject();
                } else if (o instanceof PGPSignatureList) {
                    signatureList = (PGPSignatureList)o;
                } else {
                    this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_CouldNotLoadSignature));
                    return;
                }
                signatureList.iterator().forEachRemaining(this.signaturesToVerify::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_CouldNotLoadSignature, (Throwable)ex));
            return;
        }
        if (this.signaturesToVerify.isEmpty()) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        IArtifactRepository repository = context.getRepository();
        Map<Long, PGPPublicKey> signerKeys = this.readPublicKeys(context.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME), repository != null ? repository.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME) : null);
        for (PGPSignature signature : this.signaturesToVerify) {
            PGPPublicKey publicKey = signerKeys.get(signature.getKeyID());
            if (publicKey == null) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_publicKeyNotFound, (Object)signature.getKeyID())));
                return;
            }
            try {
                signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)new BouncyCastleProvider()), publicKey);
            }
            catch (PGPException ex) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                return;
            }
        }
    }

    private String unnormalizedPGPProperty(String value) {
        if (value == null) {
            return null;
        }
        return value.replace(' ', '\n').replace("-----BEGIN\nPGP\nSIGNATURE-----", "-----BEGIN PGP SIGNATURE-----").replace("-----END\nPGP\nSIGNATURE-----", "-----END PGP SIGNATURE-----").replace("-----BEGIN\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----BEGIN PGP PUBLIC KEY BLOCK-----").replace("-----END\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----END PGP PUBLIC KEY BLOCK-----");
    }

    private Map<Long, PGPPublicKey> readPublicKeys(String armoredPublicKeyring) {
        if (armoredPublicKeyring == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, PGPPublicKey> res = new HashMap<Long, PGPPublicKey>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(this.unnormalizedPGPProperty(armoredPublicKeyring).getBytes()));){
                JcaPGPPublicKeyRingCollection pgpPub = new JcaPGPPublicKeyRingCollection(stream);
                pgpPub.getKeyRings().forEachRemaining(kRing -> kRing.getPublicKeys().forEachRemaining(key -> {
                    PGPPublicKey pGPPublicKey = res.put(key.getKeyID(), (PGPPublicKey)key);
                }));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", e.getMessage(), e));
        }
        return res;
    }

    private Map<Long, PGPPublicKey> readPublicKeys(String ... armoredPublicKeys) {
        HashMap<Long, PGPPublicKey> keys = new HashMap<Long, PGPPublicKey>();
        String[] stringArray = armoredPublicKeys;
        int n = armoredPublicKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String armoredKey = stringArray[n2];
            if (armoredKey != null) {
                keys.putAll(this.readPublicKeys(armoredKey));
            }
            ++n2;
        }
        return keys;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update((byte)b));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getDestination().write(b);
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update(b));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDestination().write(b, off, len);
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update(b, off, len));
        }
    }

    @Override
    public void close() {
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.signaturesToVerify == null || this.signaturesToVerify.isEmpty()) {
            return;
        }
        for (PGPSignature signature : this.signaturesToVerify) {
            try {
                if (signature.verify()) continue;
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_SignatureAndFileDontMatch));
                return;
            }
            catch (PGPException ex) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                return;
            }
        }
        this.setStatus(Status.OK_STATUS);
    }
}

