/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.perf.profiling.core.callgraph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callstack2.CallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.CallStackGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.model.ISamplingDataProvider;
import org.eclipse.tracecompass.analysis.profiling.core.sampled.callgraph.ProfilingCallGraphAnalysisModule;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class PerfCallchainAnalysisModule
extends ProfilingCallGraphAnalysisModule
implements ISamplingDataProvider {
    public static final String ID = "org.eclipse.tracecompass.extension.perf.profiling.core.callchain";
    private static final String EVENT_SAMPLING = "cycles";
    private static final String FIELD_PERF_CALLCHAIN = "perf_callchain";
    private static final String FIELD_PERF_PID = "perf_pid";
    private static final String FIELD_PERF_TID = "perf_tid";
    private final CallStackGroupDescriptor fThreadDescriptor = new CallStackGroupDescriptor("Threads", null, false);
    private final CallStackGroupDescriptor fProcessDescriptor = new CallStackGroupDescriptor("Process", (ICallStackGroupDescriptor)this.fThreadDescriptor, true);

    protected @Nullable Pair<ICallStackElement, AggregatedCallSite> getProfiledStackTrace(@NonNull ITmfEvent event) {
        if (!event.getName().startsWith(EVENT_SAMPLING)) {
            return null;
        }
        ITmfEventField field = event.getContent().getField(new String[]{FIELD_PERF_CALLCHAIN});
        if (field == null) {
            return null;
        }
        long[] value = (long[])field.getValue();
        int size = value.length;
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            long tmp = value[i];
            value[i] = value[j];
            value[j] = tmp;
            ++i;
            --j;
        }
        ICallStackElement element = this.getElement(event);
        return new Pair((Object)element, (Object)this.getCallSite(element, value, event.getTimestamp().getValue()));
    }

    private ICallStackElement getElement(ITmfEvent event) {
        Collection rootElements = this.getRootElements();
        Long pidField = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_PERF_PID});
        final Long pid = pidField == null ? -1L : pidField;
        Long tidField = (Long)event.getContent().getFieldValue(Long.class, new String[]{FIELD_PERF_TID});
        Long tid = tidField == null ? -1L : tidField;
        Optional<ICallStackElement> process = rootElements.stream().filter(e -> e.getName().equals(String.valueOf(pid))).findFirst();
        if (!process.isPresent()) {
            CallStackElement processEl = new CallStackElement(String.valueOf(pid), (IWeightedTreeGroupDescriptor)this.fProcessDescriptor, (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, null){

                protected int retrieveSymbolKeyAt(long time) {
                    return pid.intValue();
                }
            };
            CallStackElement threadEl = new CallStackElement(String.valueOf(tid), (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, null, (ICallStackElement)processEl);
            processEl.setSymbolKeyElement((ICallStackElement)processEl);
            threadEl.setSymbolKeyElement((ICallStackElement)processEl);
            processEl.addChild((ITree)threadEl);
            this.addRootElement((ICallStackElement)processEl);
            return threadEl;
        }
        ICallStackElement processEl = process.get();
        Optional<ICallStackElement> thread = processEl.getChildrenElements().stream().filter(e -> e.getName().equals(String.valueOf(tid))).findFirst();
        if (thread.isPresent()) {
            return thread.get();
        }
        CallStackElement threadEl = new CallStackElement(String.valueOf(tid), (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, null, processEl);
        processEl.addChild((ITree)threadEl);
        return threadEl;
    }

    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        return ImmutableList.of((Object)this.fProcessDescriptor);
    }

    public Map<String, Collection<Object>> getCallStack(@NonNull ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{FIELD_PERF_CALLCHAIN});
        if (field == null) {
            return Collections.emptyMap();
        }
        Object value = field.getValue();
        if (!(value instanceof long[])) {
            return Collections.emptyMap();
        }
        long[] callstack = (long[])value;
        ArrayList<Long> longList = new ArrayList<Long>();
        long[] lArray = callstack;
        int n = callstack.length;
        int n2 = 0;
        while (n2 < n) {
            long callsite = lArray[n2];
            longList.add(callsite);
            ++n2;
        }
        Collections.reverse(longList);
        return ImmutableMap.of((Object)"Callchain", longList);
    }

    public Collection<AggregatedCallSite> getSamplingData(int tid, long start, long end) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptyList();
        }
        ArrayList<AggregatedCallSite> callsites = new ArrayList<AggregatedCallSite>();
        PerfProfilingEventRequest request = new PerfProfilingEventRequest(trace, start, end, tid, callsites);
        trace.sendRequest((ITmfEventRequest)request);
        try {
            request.waitForCompletion();
        }
        catch (InterruptedException interruptedException) {}
        return callsites;
    }

    public Collection<String> getHostIds() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(trace.getHostId());
    }

    private class PerfProfilingEventRequest
    extends TmfEventRequest {
        private final int fTid;
        private final ITmfTrace fTrace;
        private final List<AggregatedCallSite> fSites;

        public PerfProfilingEventRequest(ITmfTrace trace, long start, long end, int tid, List<AggregatedCallSite> callsites) {
            super(TmfEvent.class, new TmfTimeRange(TmfTimestamp.fromNanos((long)start), TmfTimestamp.fromNanos((long)end)), 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fTid = tid;
            this.fTrace = trace;
            this.fSites = callsites;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.fTrace) {
                this.handleEvent(event);
            } else if (this.fTrace instanceof TmfExperiment) {
                for (ITmfTrace childTrace : ((TmfExperiment)this.fTrace).getTraces()) {
                    if (childTrace != event.getTrace()) continue;
                    this.handleEvent(event);
                }
            }
        }

        private void handleEvent(ITmfEvent event) {
            Long tidField = (Long)event.getContent().getFieldValue(Long.class, new String[]{PerfCallchainAnalysisModule.FIELD_PERF_TID});
            Long tid = tidField == null ? -1L : tidField;
            if (tid.intValue() != this.fTid) {
                return;
            }
            Pair<ICallStackElement, AggregatedCallSite> stackTrace = PerfCallchainAnalysisModule.this.getProfiledStackTrace(event);
            if (stackTrace == null) {
                return;
            }
            AggregatedCallSite perfCallSite = (AggregatedCallSite)stackTrace.getSecond();
            for (AggregatedCallSite site : this.fSites) {
                if (!((ICallStackSymbol)site.getObject()).equals(perfCallSite.getObject())) continue;
                site.merge((WeightedTree)perfCallSite);
                return;
            }
            this.fSites.add(perfCallSite);
        }
    }
}

